/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.lucene.util.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.PasswordProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexRulesPasswordProvider
implements PasswordProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private LinkedHashMap<Pattern, String> passwordMap = new LinkedHashMap();
    private String explicitPassword;

    public String getPassword(Metadata meta) {
        if (this.getExplicitPassword() != null) {
            return this.getExplicitPassword();
        }
        if (this.passwordMap.size() > 0) {
            return this.lookupPasswordFromMap(meta.get("resourceName"));
        }
        return null;
    }

    private String lookupPasswordFromMap(String fileName) {
        if (fileName != null && fileName.length() > 0) {
            for (Map.Entry<Pattern, String> e : this.passwordMap.entrySet()) {
                if (!e.getKey().matcher(fileName).matches()) continue;
                return e.getValue();
            }
        }
        return null;
    }

    public static LinkedHashMap<Pattern, String> parseRulesFile(InputStream is) {
        LinkedHashMap<Pattern, String> rules = new LinkedHashMap<Pattern, String>();
        BufferedReader br = new BufferedReader(IOUtils.getDecodingReader((InputStream)is, (Charset)StandardCharsets.UTF_8));
        try {
            String line;
            int linenum = 0;
            while ((line = br.readLine()) != null) {
                ++linenum;
                String[] arr = line.split("#");
                if (arr.length > 0) {
                    line = arr[0].trim();
                }
                if (line.length() == 0) continue;
                int sep = line.indexOf(61);
                if (sep <= 0) {
                    log.warn("Wrong format of password line {}", (Object)linenum);
                    continue;
                }
                String pass = line.substring(sep + 1).trim();
                String regex = line.substring(0, sep).trim();
                try {
                    Pattern pattern = Pattern.compile(regex);
                    rules.put(pattern, pass);
                }
                catch (PatternSyntaxException pse) {
                    log.warn("Key of line {} was not a valid regex pattern{}", (Object)linenum, (Object)pse);
                }
            }
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return rules;
    }

    public void parse(InputStream is) {
        this.setPasswordMap(RegexRulesPasswordProvider.parseRulesFile(is));
    }

    public LinkedHashMap<Pattern, String> getPasswordMap() {
        return this.passwordMap;
    }

    public void setPasswordMap(LinkedHashMap<Pattern, String> linkedHashMap) {
        this.passwordMap = linkedHashMap;
    }

    public String getExplicitPassword() {
        return this.explicitPassword;
    }

    public void setExplicitPassword(String explicitPassword) {
        this.explicitPassword = explicitPassword;
    }

    public void resetExplicitPassword() {
        this.explicitPassword = null;
    }
}

