/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security.hadoop;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.hadoop.AttributeOnlyServletContext;
import org.apache.solr.security.hadoop.HadoopAuthFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="9.8")
public class HadoopAuthPlugin
extends AuthenticationPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String HADOOP_AUTH_TYPE = "type";
    private static final String SYSPROP_PREFIX_PROPERTY = "sysPropPrefix";
    private static final String AUTH_CONFIG_NAMES_PROPERTY = "authConfigs";
    private static final String DEFAULT_AUTH_CONFIGS_PROPERTY = "defaultConfigs";
    private static final String DELEGATION_TOKEN_ENABLED_PROPERTY = "enableDelegationToken";
    private static final String INIT_KERBEROS_ZK = "initKerberosZk";
    public static final String PROXY_USER_CONFIGS = "proxyUserConfigs";
    private static final boolean TRACE_HTTP = Boolean.getBoolean("hadoopauth.tracehttp");
    private AuthenticationFilter authFilter;
    protected final CoreContainer coreContainer;
    private boolean delegationTokenEnabled;

    public HadoopAuthPlugin(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    public void init(Map<String, Object> pluginConfig) {
        try {
            this.delegationTokenEnabled = Boolean.parseBoolean((String)pluginConfig.get(DELEGATION_TOKEN_ENABLED_PROPERTY));
            this.authFilter = this.delegationTokenEnabled ? new HadoopAuthFilter() : new AuthenticationFilter();
            boolean initKerberosZk = Boolean.parseBoolean((String)pluginConfig.getOrDefault(INIT_KERBEROS_ZK, "false"));
            if (initKerberosZk) {
                new Krb5HttpClientBuilder().getBuilder();
            }
            FilterConfig conf = this.getInitFilterConfig(pluginConfig);
            this.authFilter.init(conf);
        }
        catch (ServletException e) {
            log.error("Error initializing {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error initializing " + ((Object)((Object)this)).getClass().getName() + ": " + e);
        }
    }

    protected FilterConfig getInitFilterConfig(Map<String, Object> pluginConfig) {
        ZkController controller;
        final HashMap<Object, String> params = new HashMap<Object, String>();
        String type = (String)Objects.requireNonNull(pluginConfig.get(HADOOP_AUTH_TYPE));
        params.put(HADOOP_AUTH_TYPE, type);
        String sysPropPrefix = (String)pluginConfig.getOrDefault(SYSPROP_PREFIX_PROPERTY, "solr.");
        Collection authConfigNames = pluginConfig.getOrDefault(AUTH_CONFIG_NAMES_PROPERTY, Collections.emptyList());
        Map authConfigDefaults = pluginConfig.getOrDefault(DEFAULT_AUTH_CONFIGS_PROPERTY, Collections.emptyMap());
        Map proxyUserConfigs = pluginConfig.getOrDefault(PROXY_USER_CONFIGS, Collections.emptyMap());
        for (String configName : authConfigNames) {
            String defaultConfigVal;
            String systemProperty = sysPropPrefix + configName;
            String configVal = EnvUtils.getProperty((String)systemProperty, (String)(defaultConfigVal = (String)authConfigDefaults.get(configName)));
            if (configVal == null) continue;
            params.put(configName, configVal);
        }
        if (this.delegationTokenEnabled) {
            params.putIfAbsent("delegation-token.token-kind", "solr-dt");
        }
        params.putAll(proxyUserConfigs);
        params.put("delegation-token.json-mapper." + JsonGenerator.Feature.AUTO_CLOSE_TARGET, "false");
        final AttributeOnlyServletContext servletContext = new AttributeOnlyServletContext();
        if (log.isInfoEnabled()) {
            log.info("Params: {}", params);
        }
        if ((controller = this.coreContainer.getZkController()) != null) {
            servletContext.setAttribute("solr.kerberos.delegation.token.zk.client", controller.getZkClient());
        }
        FilterConfig conf = new FilterConfig(){

            public ServletContext getServletContext() {
                return servletContext;
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(params.keySet());
            }

            public String getInitParameter(String param) {
                return (String)params.get(param);
            }

            public String getFilterName() {
                return "HadoopAuthFilter";
            }
        };
        return conf;
    }

    public boolean doAuthenticate(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        if (TRACE_HTTP) {
            log.info("----------HTTP Request---------");
            if (log.isInfoEnabled()) {
                log.info("{} : {}", (Object)request.getMethod(), (Object)request.getRequestURI());
                log.info("Query : {}", (Object)request.getQueryString());
            }
            log.info("Headers :");
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String name = (String)headers.nextElement();
                Enumeration hvals = request.getHeaders(name);
                while (hvals.hasMoreElements()) {
                    if (!log.isInfoEnabled()) continue;
                    log.info("{} : {}", (Object)name, hvals.nextElement());
                }
            }
            log.info("-------------------------------");
        }
        this.authFilter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        switch (response.getStatus()) {
            case 401: {
                this.numWrongCredentials.inc();
                break;
            }
            case 403: {
                this.numErrors.mark();
                break;
            }
            default: {
                if (response.getStatus() >= 200 && response.getStatus() <= 299) {
                    this.numAuthenticated.inc();
                    break;
                }
                this.numErrors.mark();
            }
        }
        if (TRACE_HTTP) {
            log.info("----------HTTP Response---------");
            if (log.isInfoEnabled()) {
                log.info("Status : {}", (Object)response.getStatus());
            }
            log.info("Headers :");
            for (String name : response.getHeaderNames()) {
                for (String value : response.getHeaders(name)) {
                    log.info("{} : {}", (Object)name, (Object)value);
                }
            }
            log.info("-------------------------------");
        }
        if (this.authFilter instanceof HadoopAuthFilter) {
            String requestContinuesAttr = (String)request.getAttribute("org.apache.solr.security.authentication.requestcontinues");
            if (requestContinuesAttr == null) {
                log.warn("Could not find {}", (Object)"org.apache.solr.security.authentication.requestcontinues");
                return false;
            }
            return Boolean.parseBoolean(requestContinuesAttr);
        }
        return true;
    }

    public void close() throws IOException {
        if (this.authFilter != null) {
            this.authFilter.destroy();
        }
    }
}

