/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.LocalizedException;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.InternationalString;

public final class LocalizedParseException
extends ParseException
implements LocalizedException {
    private static final long serialVersionUID = -1467571540435486742L;
    private final transient short key;
    private final transient Object[] parameters;

    public LocalizedParseException(Locale locale, short s, Object[] objectArray, int n) {
        super(Errors.getResources(locale).getString(s, objectArray), n);
        this.parameters = objectArray;
        this.key = s;
    }

    public LocalizedParseException(Locale locale, Class<?> clazz, CharSequence charSequence, ParsePosition parsePosition) {
        this(locale, clazz, charSequence, parsePosition != null ? parsePosition.getIndex() : 0, parsePosition != null ? parsePosition.getErrorIndex() : 0);
    }

    private LocalizedParseException(Locale locale, Class<?> clazz, CharSequence charSequence, int n, int n2) {
        this(locale, LocalizedParseException.parameters(clazz, charSequence, n, Math.max(n, n2)), n2);
    }

    private LocalizedParseException(Locale locale, Object[] objectArray, int n) {
        this(locale, LocalizedParseException.key(objectArray), objectArray, n);
    }

    private static Object[] parameters(Class<?> clazz, CharSequence charSequence, int n, int n2) {
        if (n2 >= charSequence.length()) {
            return new Object[]{charSequence};
        }
        CharSequence charSequence2 = CharSequences.token(charSequence, n2);
        charSequence = charSequence.subSequence(n, charSequence.length());
        if (charSequence2.length() == 0) {
            return new Object[]{clazz, charSequence};
        }
        return new Object[]{clazz, charSequence, charSequence2};
    }

    private static short key(Object[] objectArray) {
        short s;
        switch (objectArray.length) {
            case 1: {
                s = 138;
                break;
            }
            case 2: {
                s = 154;
                break;
            }
            case 3: {
                s = 155;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return s;
    }

    @Override
    public String getMessage() {
        return this.key != 0 ? Errors.format(this.key, this.parameters) : super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return super.getMessage();
    }

    @Override
    public InternationalString getInternationalMessage() {
        return this.key != 0 ? Errors.formatInternational(this.key, this.parameters) : null;
    }

    @Override
    public LocalizedParseException initCause(Throwable throwable) {
        return (LocalizedParseException)super.initCause(throwable);
    }
}

