/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.MismatchedCoverageRangeException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.SliceGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.coverage.j2d.Colorizer;
import org.apache.sis.internal.coverage.j2d.DeferredProperty;
import org.apache.sis.internal.coverage.j2d.RasterFactory;
import org.apache.sis.internal.coverage.j2d.TiledImage;
import org.apache.sis.internal.coverage.j2d.WritableTiledImage;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

public class ImageRenderer {
    private final GridGeometry geometry;
    private final GridExtent sliceExtent;
    private final int[] gridDimensions;
    private GridGeometry imageGeometry;
    private final long offsetZ;
    private final long offsetX;
    private final long offsetY;
    private final int imageX;
    private final int imageY;
    private final int width;
    private final int height;
    private final int pixelStride;
    private final int scanlineStride;
    private int strideFactor;
    private final SampleDimension[] bands;
    private int[] bandOffsets;
    private int[] bankIndices;
    private int visibleBand;
    private DataBuffer buffer;
    private Function<Category, Color[]> colors;
    private Hashtable<String, Object> properties;
    private static final MathTransformFactory mtFactory = null;

    public ImageRenderer(GridCoverage gridCoverage, GridExtent gridExtent) {
        ArgumentChecks.ensureNonNull("coverage", gridCoverage);
        this.bands = CollectionsExt.toArray(gridCoverage.getSampleDimensions(), SampleDimension.class);
        this.geometry = gridCoverage.getGridGeometry();
        GridExtent gridExtent2 = this.geometry.getExtent();
        int n = gridExtent2.getDimension();
        this.sliceExtent = gridExtent;
        if (gridExtent != null) {
            if (gridExtent.getDimension() != n) {
                throw new MismatchedDimensionException(Errors.format((short)81, "sliceExtent", n, gridExtent.getDimension()));
            }
        } else {
            gridExtent = gridExtent2;
        }
        this.gridDimensions = gridExtent.getSubspaceDimensions(2);
        int n2 = this.gridDimensions[0];
        int n3 = this.gridDimensions[1];
        long l = gridExtent2.getLow(n2);
        long l2 = gridExtent2.getLow(n3);
        long l3 = gridExtent.getLow(n2);
        long l4 = gridExtent.getLow(n3);
        long l5 = Math.max(l3, l);
        long l6 = Math.max(l4, l2);
        long l7 = Math.min(gridExtent.getHigh(n2), gridExtent2.getHigh(n2));
        long l8 = Math.min(gridExtent.getHigh(n3), gridExtent2.getHigh(n3));
        if (l7 < l5 || l8 < l6) {
            int n4 = l7 < l5 ? n2 : n3;
            throw new DisjointExtentException(gridExtent2, gridExtent, n4);
        }
        this.width = Math.incrementExact(Math.toIntExact(l7 - l5));
        this.height = Math.incrementExact(Math.toIntExact(l8 - l6));
        this.imageX = Math.toIntExact(Math.subtractExact(l5, l3));
        this.imageY = Math.toIntExact(Math.subtractExact(l6, l4));
        this.offsetX = Math.subtractExact(l5, l);
        this.offsetY = Math.subtractExact(l6, l2);
        long l9 = 1L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        for (int i = 0; i < n; ++i) {
            if (i == n2) {
                l10 = l9;
            } else if (i == n3) {
                l11 = l9;
            } else {
                long l13 = gridExtent2.getLow(i);
                long l14 = gridExtent.getLow(i);
                if (l14 > l13) {
                    l12 = Math.addExact(l12, Math.multiplyExact(l9, l14 - l13));
                }
            }
            l9 = Math.multiplyExact(l9, gridExtent2.getSize(i));
        }
        this.pixelStride = Math.toIntExact(l10);
        this.scanlineStride = Math.toIntExact(l11);
        this.offsetZ = l12;
        this.colors = Colorizer.GRAYSCALE;
    }

    public final int getNumBands() {
        return this.bands.length;
    }

    private void ensureExpectedBandCount(int n, boolean bl) {
        int n2;
        if (!(n == 1 & bl) && n != (n2 = this.getNumBands())) {
            throw new MismatchedCoverageRangeException(Resources.format((short)67, n2, n));
        }
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.imageX, this.imageY, this.width, this.height);
    }

    public GridGeometry getImageGeometry(int n) {
        GridGeometry gridGeometry = this.imageGeometry;
        if (gridGeometry == null || n != 2) {
            if (this.isSameGeometry(n)) {
                gridGeometry = this.geometry;
            } else {
                try {
                    gridGeometry = new SliceGeometry(this.geometry, this.sliceExtent, this.gridDimensions, mtFactory).reduce(new GridExtent(this.imageX, this.imageY, this.width, this.height), n);
                }
                catch (FactoryException factoryException) {
                    throw SliceGeometry.canNotCompute(factoryException);
                }
            }
            if (n == 2) {
                this.imageGeometry = gridGeometry;
            }
        }
        return gridGeometry;
    }

    public Object getProperty(String string) {
        if ("org.apache.sis.GridGeometry".equals(string)) {
            return this.getImageGeometry(2);
        }
        return this.properties != null ? this.properties.get(string) : null;
    }

    public void addProperty(String string, Object object) {
        ArgumentChecks.ensureNonNull("key", string);
        ArgumentChecks.ensureNonNull("value", object);
        if (!"org.apache.sis.GridGeometry".equals(string)) {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            if (this.properties.putIfAbsent(string, object) == null) {
                return;
            }
        }
        throw new IllegalArgumentException(Errors.format((short)27, string));
    }

    private boolean isSameGeometry(int n) {
        int n2 = this.geometry.getTargetDimension();
        ArgumentChecks.ensureBetween("dimCRS", 2, n2, n);
        if (n2 == n && this.geometry.getDimension() == this.gridDimensions.length) {
            GridExtent gridExtent = this.geometry.extent;
            if (this.sliceExtent == null) {
                return gridExtent == null || gridExtent.startsAtZero();
            }
            if (this.sliceExtent.equals(gridExtent, ComparisonMode.IGNORE_METADATA)) {
                return this.sliceExtent.startsAtZero();
            }
        }
        return false;
    }

    public void setData(DataBuffer dataBuffer) {
        ArgumentChecks.ensureNonNull("data", dataBuffer);
        this.ensureExpectedBandCount(dataBuffer.getNumBanks(), true);
        this.buffer = dataBuffer;
    }

    public void setData(DataType dataType, Buffer ... bufferArray) {
        ArgumentChecks.ensureNonNull("dataType", (Object)dataType);
        ArgumentChecks.ensureNonNull("data", bufferArray);
        this.ensureExpectedBandCount(bufferArray.length, true);
        this.setData(RasterFactory.wrap(dataType, bufferArray));
    }

    public void setData(Vector ... vectorArray) {
        ArgumentChecks.ensureNonNull("data", vectorArray);
        this.ensureExpectedBandCount(vectorArray.length, true);
        Buffer[] bufferArray = new Buffer[vectorArray.length];
        DataType dataType = null;
        for (int i = 0; i < vectorArray.length; ++i) {
            Vector vector = vectorArray[i];
            ArgumentChecks.ensureNonNullElement("data", i, vector);
            DataType dataType2 = DataType.forPrimitiveType(vector.getElementType(), vector.isUnsigned());
            if (dataType == null) {
                dataType = dataType2;
            } else if (dataType != dataType2) {
                throw new RasterFormatException(Resources.format((short)42));
            }
            bufferArray[i] = vector.buffer().orElseThrow(UnsupportedOperationException::new);
        }
        this.setData(dataType, bufferArray);
    }

    public void setInterleavedPixelOffsets(int n, int[] nArray) {
        ArgumentChecks.ensureStrictlyPositive("pixelStride", n);
        ArgumentChecks.ensureNonNull("bandOffsets", nArray);
        this.ensureExpectedBandCount(nArray.length, false);
        this.strideFactor = n;
        this.bandOffsets = (int[])nArray.clone();
    }

    public void setVisibleBand(int n) {
        ArgumentChecks.ensureBetween("band", 0, this.getNumBands() - 1, n);
        this.visibleBand = n;
    }

    public void setCategoryColors(Function<Category, Color[]> function) {
        ArgumentChecks.ensureNonNull("colors", function);
        this.colors = function;
    }

    public Raster createRaster() {
        boolean bl;
        if (this.buffer == null) {
            throw new IllegalStateException(Resources.format((short)74));
        }
        boolean bl2 = bl = this.buffer.getNumBanks() == 1;
        if (this.bandOffsets == null) {
            this.strideFactor = bl ? this.getNumBands() : 1;
        }
        int n = Math.multiplyExact(this.scanlineStride, this.strideFactor);
        int n2 = this.pixelStride * this.strideFactor;
        int[] nArray = new int[this.getNumBands()];
        Arrays.fill(nArray, Math.toIntExact(Math.addExact(Math.addExact(Math.multiplyExact(this.offsetX, (long)n2), Math.multiplyExact(this.offsetY, (long)n)), this.offsetZ)));
        if (this.bandOffsets != null || bl) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = Math.addExact(nArray[i], this.bandOffsets != null ? this.bandOffsets[i] : i);
            }
        }
        Point point = new Point(this.imageX, this.imageY);
        return RasterFactory.createRaster(this.buffer, this.width, this.height, n2, n, this.bankIndices, nArray, point);
    }

    public RenderedImage createImage() {
        WritableRaster writableRaster;
        Colorizer colorizer = new Colorizer(this.colors);
        Raster raster = this.createRaster();
        SampleModel sampleModel = raster.getSampleModel();
        ColorModel colorModel = colorizer.initialize(sampleModel, this.bands[this.visibleBand]) || colorizer.initialize(sampleModel, this.visibleBand) ? colorizer.createColorModel(this.buffer.getDataType(), this.bands.length, this.visibleBand) : Colorizer.NULL_COLOR_MODEL;
        SliceGeometry sliceGeometry = null;
        if (this.imageGeometry == null) {
            if (this.isSameGeometry(2)) {
                this.imageGeometry = this.geometry;
            } else {
                sliceGeometry = new SliceGeometry(this.geometry, this.sliceExtent, this.gridDimensions, mtFactory);
            }
        }
        WritableRaster writableRaster2 = writableRaster = raster instanceof WritableRaster ? (WritableRaster)raster : null;
        if (writableRaster != null && colorModel != null && (this.imageX | this.imageY) == 0) {
            return new Untiled(colorModel, writableRaster, this.properties, this.imageGeometry, sliceGeometry);
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.putIfAbsent("org.apache.sis.GridGeometry", sliceGeometry != null ? new DeferredProperty(sliceGeometry) : this.imageGeometry);
        if (writableRaster != null) {
            return new WritableTiledImage((Map<String, Object>)this.properties, colorModel, this.width, this.height, 0, 0, writableRaster);
        }
        return new TiledImage(this.properties, colorModel, this.width, this.height, 0, 0, raster);
    }

    private static final class Untiled
    extends BufferedImage {
        private GridGeometry geometry;
        private SliceGeometry supplier;

        Untiled(ColorModel colorModel, WritableRaster writableRaster, Hashtable<?, ?> hashtable, GridGeometry gridGeometry, SliceGeometry sliceGeometry) {
            super(colorModel, writableRaster, false, hashtable);
            this.geometry = gridGeometry;
            this.supplier = sliceGeometry;
        }

        @Override
        public String[] getPropertyNames() {
            return ArraysExt.concatenate(super.getPropertyNames(), {"org.apache.sis.GridGeometry"});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getProperty(String string) {
            if (!"org.apache.sis.GridGeometry".equals(string)) {
                return super.getProperty(string);
            }
            Untiled untiled = this;
            synchronized (untiled) {
                SliceGeometry sliceGeometry;
                if (this.geometry == null && (sliceGeometry = this.supplier) != null) {
                    this.supplier = null;
                    this.geometry = sliceGeometry.apply(this);
                }
            }
            return this.geometry;
        }
    }
}

