/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSSEC;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;

class DNSSECWithBC {
    DNSSECWithBC() {
    }

    static PublicKey toPublicKey(int alg, byte[] key) throws DNSSEC.DNSSECException, GeneralSecurityException, IOException {
        switch (alg) {
            case 15: {
                return DNSSECWithBC.toEdDSAPublicKey(key, EdECObjectIdentifiers.id_Ed25519);
            }
            case 16: {
                return DNSSECWithBC.toEdDSAPublicKey(key, EdECObjectIdentifiers.id_Ed448);
            }
        }
        throw new DNSSEC.UnsupportedAlgorithmException(alg);
    }

    static byte[] fromPublicKey(PublicKey key, int alg) throws DNSSEC.DNSSECException {
        switch (alg) {
            case 15: 
            case 16: {
                if (!(key instanceof BCEdDSAPublicKey) || !key.getFormat().equalsIgnoreCase("X.509")) {
                    throw new DNSSEC.IncompatibleKeyException();
                }
                return DNSSECWithBC.fromEdDSAPublicKey(key);
            }
        }
        throw new DNSSEC.UnsupportedAlgorithmException(alg);
    }

    private static PublicKey toEdDSAPublicKey(byte[] key, ASN1ObjectIdentifier algId) throws GeneralSecurityException, IOException {
        SubjectPublicKeyInfo keyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(algId), key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyInfo.getEncoded());
        KeyFactory keyFactory = KeyFactory.getInstance("EdDSA");
        return keyFactory.generatePublic(keySpec);
    }

    private static byte[] fromEdDSAPublicKey(PublicKey key) {
        DNSOutput out = new DNSOutput();
        byte[] encoded = key.getEncoded();
        out.writeByteArray(encoded, 12, encoded.length - 12);
        return out.toByteArray();
    }
}

