/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part1.objectdescriptors;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.AudioSpecificConfig;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BaseDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.DecoderConfigDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.DecoderSpecificInfo;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.Descriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ESDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ExtensionDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ExtensionProfileLevelDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ObjectDescriptorBase;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ProfileLevelIndicationDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.SLConfigDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.UnknownDescriptor;
import org.mp4parser.tools.IsoTypeReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDescriptorFactory {
    protected static Logger LOG = LoggerFactory.getLogger(ObjectDescriptorFactory.class);
    protected static Map<Integer, Map<Integer, Class<? extends BaseDescriptor>>> descriptorRegistry = new HashMap<Integer, Map<Integer, Class<? extends BaseDescriptor>>>();

    static {
        HashSet<Class> annotated = new HashSet<Class>();
        annotated.add(DecoderSpecificInfo.class);
        annotated.add(SLConfigDescriptor.class);
        annotated.add(BaseDescriptor.class);
        annotated.add(ExtensionDescriptor.class);
        annotated.add(ObjectDescriptorBase.class);
        annotated.add(ProfileLevelIndicationDescriptor.class);
        annotated.add(AudioSpecificConfig.class);
        annotated.add(ExtensionProfileLevelDescriptor.class);
        annotated.add(ESDescriptor.class);
        annotated.add(DecoderConfigDescriptor.class);
        for (Class clazz : annotated) {
            Descriptor descriptor = clazz.getAnnotation(Descriptor.class);
            int[] tags = descriptor.tags();
            int objectTypeInd = descriptor.objectTypeIndication();
            Map<Integer, Class<? extends BaseDescriptor>> tagMap = descriptorRegistry.get(objectTypeInd);
            if (tagMap == null) {
                tagMap = new HashMap<Integer, Class<? extends BaseDescriptor>>();
            }
            int[] nArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                int tag = nArray[n2];
                tagMap.put(tag, clazz);
                ++n2;
            }
            descriptorRegistry.put(objectTypeInd, tagMap);
        }
    }

    public static BaseDescriptor createFrom(int objectTypeIndication, ByteBuffer bb) throws IOException {
        BaseDescriptor baseDescriptor;
        Class<? extends BaseDescriptor> aClass;
        int tag = IsoTypeReader.readUInt8(bb);
        Map<Integer, Class<? extends BaseDescriptor>> tagMap = descriptorRegistry.get(objectTypeIndication);
        if (tagMap == null) {
            tagMap = descriptorRegistry.get(-1);
        }
        if ((aClass = tagMap.get(tag)) == null || aClass.isInterface() || Modifier.isAbstract(aClass.getModifiers())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("No ObjectDescriptor found for objectTypeIndication {} and tag {} found: {}", new Object[]{Integer.toHexString(objectTypeIndication), Integer.toHexString(tag), aClass});
            }
            baseDescriptor = new UnknownDescriptor();
        } else {
            try {
                baseDescriptor = aClass.newInstance();
            }
            catch (Exception e) {
                LOG.error("Couldn't instantiate BaseDescriptor class " + aClass + " for objectTypeIndication " + objectTypeIndication + " and tag " + tag, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        baseDescriptor.parse(tag, bb);
        return baseDescriptor;
    }
}

