/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.ai4j.openai4j.chat.Function;
import dev.ai4j.openai4j.chat.ToolType;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Tool {
    @JsonProperty
    private final ToolType type = ToolType.FUNCTION;
    @JsonProperty
    private final Function function;

    private Tool(Builder builder) {
        this.function = builder.function;
    }

    public ToolType type() {
        return this.type;
    }

    public Function function() {
        return this.function;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Tool && this.equalTo((Tool)another);
    }

    private boolean equalTo(Tool another) {
        return Objects.equals((Object)this.type, (Object)another.type) && Objects.equals(this.function, another.function);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Objects.hashCode(this.function);
        return h;
    }

    public String toString() {
        return "Tool{type=" + (Object)((Object)this.type) + ", function=" + this.function + "}";
    }

    public static Tool from(Function function) {
        return new Builder().function(function).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private Function function;

        private Builder() {
        }

        public Builder function(Function function) {
            this.function = function;
            return this;
        }

        public Tool build() {
            return new Tool(this);
        }
    }
}

