/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.tree.FieldConstruction;

public class StringKeyFieldConstruction
implements FieldConstruction {
    private final JsonQuery key;
    private final JsonQuery value;

    public StringKeyFieldConstruction(JsonQuery key, JsonQuery value) {
        this.key = key;
        this.value = value;
    }

    public StringKeyFieldConstruction(JsonQuery key) {
        this(key, null);
    }

    @Override
    public void evaluate(Scope scope, JsonNode in, FieldConstruction.FieldConsumer consumer) throws JsonQueryException {
        for (JsonNode k : this.key.apply(scope, in)) {
            if (!k.isTextual()) {
                throw new JsonQueryException("key must evaluate to string");
            }
            if (this.value == null) {
                consumer.accept(k.asText(), JsonNodeUtils.nullToNullNode(in.get(k.asText())));
                continue;
            }
            for (JsonNode v : this.value.apply(scope, in)) {
                consumer.accept(k.asText(), v);
            }
        }
    }

    public String toString() {
        if (this.value == null) {
            return this.key.toString();
        }
        return this.key.toString() + ": " + this.value.toString();
    }
}

