/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;

@BuiltinFunction(value={"tonumber/0"})
public class ToNumberFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        if (in.isNumber()) {
            return Collections.singletonList(in);
        }
        if (in.isTextual()) {
            double value;
            try {
                value = Double.parseDouble(in.asText());
            }
            catch (NumberFormatException e) {
                throw new JsonQueryException(e);
            }
            return Collections.singletonList(JsonNodeUtils.asNumericNode(value));
        }
        throw JsonQueryException.format("%s cannot be parsed as a number", in.getNodeType());
    }
}

