/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class BytesOutputStream
extends OutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected byte[] buf;
    protected int sz;

    public BytesOutputStream() {
        this(64);
    }

    public BytesOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size must be > 0: " + size);
        }
        this.buf = new byte[size];
    }

    public byte[] toBytes() {
        return Arrays.copyOf(this.buf, this.sz);
    }

    public Bytes bytes() {
        return new Bytes(this.buf, 0, this.sz);
    }

    public InputStream inputStream() {
        return new ByteArrayInputStream(this.buf);
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.expandBuf(minCapacity);
        }
    }

    @Override
    public void write(int b) {
        try {
            this.buf[this.sz] = (byte)b;
            ++this.sz;
        }
        catch (IndexOutOfBoundsException e) {
            this.ensureCapacity(this.sz + 1);
            this.buf[this.sz] = (byte)b;
            ++this.sz;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        try {
            System.arraycopy(b, off, this.buf, this.sz, len);
            this.sz += len;
        }
        catch (IndexOutOfBoundsException e) {
            this.ensureCapacity(this.sz + len);
            System.arraycopy(b, off, this.buf, this.sz, len);
            this.sz += len;
        }
    }

    public void writeBytes(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void reset() {
        this.sz = 0;
    }

    public int size() {
        return this.sz;
    }

    public String toString(String charset) {
        try {
            return new String(this.buf, 0, this.sz, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void expandBuf(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    @Override
    public void close() {
    }

    public static class Bytes {
        public final byte[] bytes;
        public final int offset;
        public final int length;

        public Bytes(byte[] bytes, int offset, int length) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }
    }
}

