/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.configuration;

import com.google.common.annotations.VisibleForTesting;
import org.apache.solr.util.configuration.SSLConfigurations;
import org.apache.solr.util.configuration.SSLCredentialProviderFactory;

public class SSLConfigurationsFactory {
    private static SSLConfigurations currentConfigurations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLConfigurations current() {
        if (currentConfigurations != null) return currentConfigurations;
        Class<SSLConfigurationsFactory> clazz = SSLConfigurationsFactory.class;
        synchronized (SSLConfigurationsFactory.class) {
            if (currentConfigurations != null) return currentConfigurations;
            currentConfigurations = SSLConfigurationsFactory.getInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentConfigurations;
        }
    }

    private static SSLConfigurations getInstance() {
        return new SSLConfigurations(new SSLCredentialProviderFactory());
    }

    @VisibleForTesting
    public static synchronized void setCurrent(SSLConfigurations configurations) {
        currentConfigurations = configurations;
    }
}

