/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.security.JWTIssuerConfig;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.VerificationJwkSelector;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UnresolvableKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTVerificationkeyResolver
implements VerificationKeyResolver {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private VerificationJwkSelector verificationJwkSelector = new VerificationJwkSelector();
    private Map<String, JWTIssuerConfig> issuerConfigs = new HashMap<String, JWTIssuerConfig>();
    private final boolean requireIssuer;

    public JWTVerificationkeyResolver(Collection<JWTIssuerConfig> issuerConfigs, boolean requireIssuer) {
        this.requireIssuer = requireIssuer;
        issuerConfigs.forEach(ic -> this.issuerConfigs.put(ic.getIss(), (JWTIssuerConfig)ic));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        JsonWebKey theChosenOne;
        ArrayList jsonWebKeys = new ArrayList();
        String keysSource = "N/A";
        try {
            JWTIssuerConfig issuerConfig;
            String tokenIssuer = JwtClaims.parse((String)jws.getUnverifiedPayload()).getIssuer();
            if (tokenIssuer == null) {
                if (this.requireIssuer) {
                    throw new UnresolvableKeyException("Token does not contain required issuer claim");
                }
                if (this.issuerConfigs.size() != 1) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Signature verifiction not supported for multiple issuers without 'iss' claim in token.");
                issuerConfig = this.issuerConfigs.values().iterator().next();
            } else {
                issuerConfig = this.issuerConfigs.get(tokenIssuer);
                if (issuerConfig == null) {
                    if (this.issuerConfigs.size() > 1) {
                        throw new UnresolvableKeyException("No issuers configured for iss='" + tokenIssuer + "', cannot validate signature");
                    }
                    if (this.issuerConfigs.size() != 1) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Signature verifiction failed due to no configured issuer with id " + tokenIssuer);
                    issuerConfig = this.issuerConfigs.values().iterator().next();
                    log.debug("No issuer matching token's iss claim, but exactly one configured, selecting that one");
                }
            }
            if (issuerConfig.usesHttpsJwk()) {
                keysSource = "[" + String.join((CharSequence)", ", issuerConfig.getJwksUrls()) + "]";
                for (HttpsJwks hjwks : issuerConfig.getHttpsJwks()) {
                    jsonWebKeys.addAll(hjwks.getJsonWebKeys());
                }
            } else {
                keysSource = "static list of keys in security.json";
                jsonWebKeys.addAll(issuerConfig.getJsonWebKeySet().getJsonWebKeys());
            }
            theChosenOne = this.verificationJwkSelector.select(jws, jsonWebKeys);
            if (theChosenOne == null && issuerConfig.usesHttpsJwk()) {
                log.debug("Refreshing JWKs from all {} locations, as no suitable verification key for JWS w/ header {} was found in {}", new Object[]{issuerConfig.getHttpsJwks().size(), jws.getHeaders().getFullHeaderAsJsonString(), jsonWebKeys});
                jsonWebKeys.clear();
                for (HttpsJwks hjwks : issuerConfig.getHttpsJwks()) {
                    hjwks.refresh();
                    jsonWebKeys.addAll(hjwks.getJsonWebKeys());
                }
                theChosenOne = this.verificationJwkSelector.select(jws, jsonWebKeys);
            }
        }
        catch (IOException | MalformedClaimException | InvalidJwtException | JoseException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find a suitable verification key for JWS w/ header ").append(jws.getHeaders().getFullHeaderAsJsonString());
            sb.append(" due to an unexpected exception (").append(e).append(") while obtaining or using keys from source ");
            sb.append(keysSource);
            throw new UnresolvableKeyException(sb.toString(), e);
        }
        if (theChosenOne != null) return theChosenOne.getKey();
        StringBuilder sb = new StringBuilder();
        sb.append("Unable to find a suitable verification key for JWS w/ header ").append(jws.getHeaders().getFullHeaderAsJsonString());
        sb.append(" from ").append(jsonWebKeys.size()).append(" keys from source ").append(keysSource);
        throw new UnresolvableKeyException(sb.toString());
    }

    Set<JWTIssuerConfig> getIssuerConfigs() {
        return new HashSet<JWTIssuerConfig>(this.issuerConfigs.values());
    }
}

