/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.IntFunction;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UnInvertedFieldAcc;

abstract class DoubleUnInvertedFieldAcc
extends UnInvertedFieldAcc {
    double[] result;
    int currentSlot;
    double initialValue;

    public DoubleUnInvertedFieldAcc(FacetContext fcontext, SchemaField sf, int numSlots, double initialValue) throws IOException {
        super(fcontext, sf, numSlots);
        this.result = new double[numSlots];
        if (initialValue != 0.0) {
            this.initialValue = initialValue;
            Arrays.fill(this.result, initialValue);
        }
    }

    @Override
    public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
        this.currentSlot = slot;
        this.docToTerm.getBigTerms(doc + this.currentDocBase, this);
        this.docToTerm.getSmallTerms(doc + this.currentDocBase, this);
    }

    @Override
    public int compare(int slotA, int slotB) {
        return Double.compare(this.result[slotA], this.result[slotB]);
    }

    @Override
    public Object getValue(int slotNum) throws IOException {
        return this.result[slotNum];
    }

    @Override
    public void reset() throws IOException {
        Arrays.fill(this.result, this.initialValue);
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        resizer.resize(this.result, this.initialValue);
    }
}

