/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SortedSetDVAcc;

abstract class DoubleSortedSetDVAcc
extends SortedSetDVAcc {
    double[] result;
    double initialValue;

    public DoubleSortedSetDVAcc(FacetContext fcontext, SchemaField sf, int numSlots, long initialValue) throws IOException {
        super(fcontext, sf, numSlots);
        this.result = new double[numSlots];
        this.initialValue = initialValue;
        if (initialValue != 0L) {
            Arrays.fill(this.result, (double)initialValue);
        }
    }

    @Override
    public int compare(int slotA, int slotB) {
        return Double.compare(this.result[slotA], this.result[slotB]);
    }

    @Override
    public Object getValue(int slotNum) throws IOException {
        return this.result[slotNum];
    }

    @Override
    public void reset() throws IOException {
        Arrays.fill(this.result, this.initialValue);
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        resizer.resize(this.result, this.initialValue);
    }
}

