/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.JsonSchemaCreator;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.SolrJacksonAnnotationInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedApi
extends Api
implements PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ERR = "Error executing commands :";
    private EndPoint endPoint;
    private Map<String, Cmd> commands = new HashMap<String, Cmd>();
    private final Api fallback;

    public AnnotatedApi(Object obj) {
        this(obj, null);
    }

    public AnnotatedApi(Object obj, Api fallback) {
        super(AnnotatedApi.readSpec(obj.getClass()));
        this.fallback = fallback;
        Class<?> klas = obj.getClass();
        if (!Modifier.isPublic(klas.getModifiers())) {
            throw new RuntimeException(obj.getClass().getName() + " is not public");
        }
        this.endPoint = klas.getAnnotation(EndPoint.class);
        for (Method m : klas.getDeclaredMethods()) {
            Command command = m.getAnnotation(Command.class);
            if (command == null) continue;
            if (this.commands.containsKey(command.name())) {
                throw new RuntimeException("Duplicate commands " + command.name());
            }
            this.commands.put(command.name(), new Cmd(command, obj, m));
        }
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return this.endPoint.permission();
    }

    private static SpecProvider readSpec(Class klas) {
        EndPoint endPoint = klas.getAnnotation(EndPoint.class);
        if (endPoint == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid class :  " + klas.getName());
        }
        return () -> {
            LinkedHashMap<String, Cloneable> map = new LinkedHashMap<String, Cloneable>();
            ArrayList<String> methods = new ArrayList<String>();
            for (SolrRequest.METHOD method : endPoint.method()) {
                methods.add(method.name());
            }
            map.put("methods", methods);
            map.put("url", (Cloneable)new ValidatingJsonMap(Collections.singletonMap("paths", Arrays.asList(endPoint.path()))));
            HashMap<String, Map<String, Object>> cmds = new HashMap<String, Map<String, Object>>();
            for (Method method : klas.getMethods()) {
                Command command = method.getAnnotation(Command.class);
                if (command == null || command.name().isEmpty()) continue;
                cmds.put(command.name(), AnnotatedApi.createSchema(method));
            }
            if (!cmds.isEmpty()) {
                map.put("commands", cmds);
            }
            return new ValidatingJsonMap(map);
        };
    }

    @Override
    public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
        Cmd cmd;
        if (this.commands.size() == 1 && (cmd = this.commands.get("")) != null) {
            cmd.invoke(req, rsp, null);
            return;
        }
        List<CommandOperation> cmds = req.getCommands(true);
        boolean allExists = true;
        for (CommandOperation cmd2 : cmds) {
            if (this.commands.containsKey(cmd2.name)) continue;
            cmd2.addError("No such command supported: " + cmd2.name);
            allExists = false;
        }
        if (!allExists) {
            if (this.fallback != null) {
                this.fallback.call(req, rsp);
                return;
            }
            throw new ApiBag.ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, "Error processing commands", CommandOperation.captureErrors(cmds));
        }
        for (CommandOperation cmd2 : cmds) {
            this.commands.get(cmd2.name).invoke(req, rsp, cmd2);
        }
        List errs = CommandOperation.captureErrors(cmds);
        if (!errs.isEmpty()) {
            log.error(ERR + Utils.toJSONString((Object)errs));
            throw new ApiBag.ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, ERR, errs);
        }
    }

    public static Map<String, Object> createSchema(Method m) {
        Type[] types = m.getGenericParameterTypes();
        if (types.length == 3) {
            ParameterizedType typ;
            Type t = types[2];
            if (t instanceof ParameterizedType && (typ = (ParameterizedType)t).getRawType() == PayloadObj.class) {
                t = typ.getActualTypeArguments()[0];
            }
            return JsonSchemaCreator.getSchema((Type)t);
        }
        return null;
    }

    class Cmd {
        final Command command;
        final Method method;
        final Object obj;
        ObjectMapper mapper = SolrJacksonAnnotationInspector.createObjectMapper();
        int paramsCount;
        Class c;
        boolean isWrappedInPayloadObj = false;

        Cmd(Command command, Object obj, Method method) {
            if (Modifier.isPublic(method.getModifiers())) {
                this.command = command;
                this.obj = obj;
                this.method = method;
                Class<?>[] parameterTypes = method.getParameterTypes();
                this.paramsCount = parameterTypes.length;
                if (parameterTypes[0] != SolrQueryRequest.class || parameterTypes[1] != SolrQueryResponse.class) {
                    throw new RuntimeException("Invalid params for method " + method);
                }
                if (parameterTypes.length == 3) {
                    Type t = method.getGenericParameterTypes()[2];
                    if (t instanceof ParameterizedType) {
                        ParameterizedType typ = (ParameterizedType)t;
                        if (typ.getRawType() == PayloadObj.class) {
                            this.isWrappedInPayloadObj = true;
                            Type t1 = typ.getActualTypeArguments()[0];
                            if (t1 instanceof ParameterizedType) {
                                ParameterizedType parameterizedType = (ParameterizedType)t1;
                                this.c = (Class)parameterizedType.getRawType();
                            } else {
                                this.c = (Class)typ.getActualTypeArguments()[0];
                            }
                        }
                    } else {
                        this.c = (Class)t;
                    }
                }
                if (parameterTypes.length > 3) {
                    throw new RuntimeException("Invalid params count for method " + method);
                }
            } else {
                throw new RuntimeException(method.toString() + " is not a public static method");
            }
        }

        void invoke(SolrQueryRequest req, SolrQueryResponse rsp, CommandOperation cmd) {
            try {
                if (this.paramsCount == 2) {
                    this.method.invoke(this.obj, req, rsp);
                } else {
                    Object o = cmd.getCommandData();
                    if (o instanceof Map && this.c != null) {
                        o = this.mapper.readValue(Utils.toJSONString((Object)o), this.c);
                    }
                    if (this.isWrappedInPayloadObj) {
                        PayloadObj<Object> payloadObj;
                        cmd = payloadObj = new PayloadObj<Object>(cmd.name, cmd.getCommandData(), o);
                        this.method.invoke(this.obj, new Object[]{req, rsp, payloadObj});
                    } else {
                        this.method.invoke(this.obj, req, rsp, o);
                    }
                    if (cmd.hasError()) {
                        throw new ApiBag.ExceptionWithErrObject(SolrException.ErrorCode.BAD_REQUEST, "Error executing command", CommandOperation.captureErrors(Collections.singletonList(cmd)));
                    }
                }
            }
            catch (SolrException se) {
                log.error("Error executing command  ", (Throwable)se);
                throw se;
            }
            catch (InvocationTargetException ite) {
                log.error("Error executing command ", (Throwable)ite);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, ite.getCause());
            }
            catch (Exception e) {
                log.error("Error executing command : ", (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }
}

