/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import org.apache.poi.sl.usermodel.PaintStyle;

class DrawTexturePaint
extends TexturePaint {
    private final PaintStyle.TexturePaint fill;
    private final Shape shape;
    private final double flipX;
    private final double flipY;
    private final boolean isBitmapSrc;

    DrawTexturePaint(BufferedImage txtr, Shape shape, PaintStyle.TexturePaint fill, double flipX, double flipY, boolean isBitmapSrc) {
        super(txtr, new Rectangle2D.Double(0.0, 0.0, txtr.getWidth(), txtr.getHeight()));
        this.fill = fill;
        this.shape = shape;
        this.flipX = flipX;
        this.flipY = flipY;
        this.isBitmapSrc = isBitmapSrc;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        double alg_y;
        double alg_x;
        double usr_h;
        double usr_w;
        if (this.fill.isRotatedWithShape() || this.shape == null) {
            usr_w = userBounds.getWidth();
            usr_h = userBounds.getHeight();
            xform.translate(userBounds.getX(), userBounds.getY());
        } else {
            AffineTransform transform = new AffineTransform(xform);
            transform.preConcatenate(AffineTransform.getTranslateInstance(-transform.getTranslateX(), -transform.getTranslateY()));
            Point2D p1 = new Point2D.Double(1.0, 0.0);
            p1 = transform.transform(p1, p1);
            double rad = Math.atan2(p1.getY(), p1.getX());
            if (rad != 0.0) {
                xform.rotate(-rad, userBounds.getCenterX(), userBounds.getCenterY());
            }
            transform = AffineTransform.getRotateInstance(rad, userBounds.getCenterX(), userBounds.getCenterY());
            Rectangle2D newBounds = transform.createTransformedShape(this.shape).getBounds2D();
            usr_w = newBounds.getWidth();
            usr_h = newBounds.getHeight();
            xform.translate(newBounds.getX(), newBounds.getY());
        }
        Dimension2D scale = this.fill.getScale();
        BufferedImage bi = this.getImage();
        double img_w = (double)bi.getWidth() * (scale == null ? 1.0 : scale.getWidth()) / this.flipX;
        double img_h = (double)bi.getHeight() * (scale == null ? 1.0 : scale.getHeight()) / this.flipY;
        PaintStyle.TextureAlignment ta = this.fill.getAlignment();
        switch (ta == null ? PaintStyle.TextureAlignment.TOP_LEFT : ta) {
            case BOTTOM: {
                alg_x = (usr_w - img_w) / 2.0;
                alg_y = usr_h - img_h;
                break;
            }
            case BOTTOM_LEFT: {
                alg_x = 0.0;
                alg_y = usr_h - img_h;
                break;
            }
            case BOTTOM_RIGHT: {
                alg_x = usr_w - img_w;
                alg_y = usr_h - img_h;
                break;
            }
            case CENTER: {
                alg_x = (usr_w - img_w) / 2.0;
                alg_y = (usr_h - img_h) / 2.0;
                break;
            }
            case LEFT: {
                alg_x = 0.0;
                alg_y = (usr_h - img_h) / 2.0;
                break;
            }
            case RIGHT: {
                alg_x = usr_w - img_w;
                alg_y = (usr_h - img_h) / 2.0;
                break;
            }
            case TOP: {
                alg_x = (usr_w - img_w) / 2.0;
                alg_y = 0.0;
                break;
            }
            default: {
                alg_x = 0.0;
                alg_y = 0.0;
                break;
            }
            case TOP_RIGHT: {
                alg_x = usr_w - img_w;
                alg_y = 0.0;
            }
        }
        xform.translate(alg_x, alg_y);
        Point2D offset = this.fill.getOffset();
        if (offset != null) {
            xform.translate(offset.getX(), offset.getY());
        }
        if (scale != null) {
            xform.scale(scale.getWidth() / (this.isBitmapSrc ? this.flipX : 1.0), scale.getHeight() / (this.isBitmapSrc ? this.flipY : 1.0));
        }
        return super.createContext(cm, deviceBounds, userBounds, xform, hints);
    }
}

