/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.query.FilterQuery;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.ExtendedQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;

public class BoolQParserPlugin
extends QParserPlugin {
    public static final String NAME = "bool";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                SolrParams solrParams = SolrParams.wrapDefaults((SolrParams)this.localParams, (SolrParams)this.params);
                this.addQueries(builder, solrParams.getParams("must"), BooleanClause.Occur.MUST);
                this.addQueries(builder, solrParams.getParams("must_not"), BooleanClause.Occur.MUST_NOT);
                this.addQueries(builder, solrParams.getParams("filter"), BooleanClause.Occur.FILTER);
                this.addQueries(builder, solrParams.getParams("should"), BooleanClause.Occur.SHOULD);
                return builder.build();
            }

            private void addQueries(BooleanQuery.Builder builder, String[] subQueries, BooleanClause.Occur occur) throws SyntaxError {
                if (subQueries != null) {
                    for (String subQuery : subQueries) {
                        Query extQuery;
                        QParser subParser = this.subQuery(subQuery, null);
                        if (BooleanClause.Occur.FILTER.equals((Object)occur)) {
                            extQuery = subParser.getQuery();
                            if (!(extQuery instanceof ExtendedQuery) || ((ExtendedQuery)extQuery).getCache()) {
                                extQuery = new FilterQuery(extQuery);
                            }
                        } else {
                            extQuery = subParser.parse();
                        }
                        builder.add(extQuery, occur);
                    }
                }
            }
        };
    }
}

