/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.carrot2.mahout.math.function.DoubleDoubleFunction;
import org.carrot2.mahout.math.function.DoubleFunction;
import org.carrot2.mahout.math.function.Functions;
import org.carrot2.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.matrix.MatrixUtils;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationBase;

public class LocalNonnegativeMatrixFactorization
extends IterativeMatrixFactorizationBase {
    public LocalNonnegativeMatrixFactorization(DoubleMatrix2D A) {
        super(A);
    }

    @Override
    public void compute() {
        double eps = 1.0E-9;
        this.U = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        this.V = new DenseDoubleMatrix2D(this.A.columns(), this.k);
        this.seedingStrategy.seed(this.A, this.U, this.V);
        DoubleMatrix2D Aeps = this.A.copy();
        Aeps.assign(Functions.plus(eps));
        DenseDoubleMatrix2D UV = new DenseDoubleMatrix2D(this.A.rows(), this.A.columns());
        DenseDoubleMatrix2D VT = new DenseDoubleMatrix2D(this.A.columns(), this.k);
        DenseDoubleMatrix2D UT = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        double[] work = new double[this.U.columns()];
        DoubleDoubleFunction invDiv = Functions.swapArgs(Functions.DIV);
        DoubleDoubleFunction sqrtMult = Functions.chain(Functions.SQRT, Functions.MULT);
        DoubleFunction plusEps = Functions.plus(eps);
        if (this.stopThreshold >= 0.0) {
            this.updateApproximationError();
        }
        for (int i = 0; i < this.maxIterations; ++i) {
            this.U.zMult(this.V, UV, 1.0, 0.0, false, true);
            ((DoubleMatrix2D)UV).assign(plusEps);
            ((DoubleMatrix2D)UV).assign(Aeps, invDiv);
            ((DoubleMatrix2D)UV).zMult(this.U, VT, 1.0, 0.0, true, false);
            this.V.assign(VT, sqrtMult);
            this.U.zMult(this.V, UV, 1.0, 0.0, false, true);
            ((DoubleMatrix2D)UV).assign(plusEps);
            ((DoubleMatrix2D)UV).assign(Aeps, invDiv);
            ((DoubleMatrix2D)UV).zMult(this.V, UT, 1.0, 0.0, false, false);
            this.U.assign(UT, Functions.MULT);
            MatrixUtils.normalizeColumnL1(this.U, work);
            ++this.iterationsCompleted;
            if (this.stopThreshold >= 0.0 && this.updateApproximationError()) break;
        }
        if (this.ordered) {
            this.order();
        }
    }

    public String toString() {
        return "LNMF-" + this.seedingStrategy.toString();
    }
}

