/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;

class BooleanValueEqualFunction
extends BooleanValue.AbstractBooleanValue {
    private final BooleanValue exprA;
    private final BooleanValue exprB;
    public static final String name = "equal";
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;

    public BooleanValueEqualFunction(BooleanValue exprA, BooleanValue exprB) {
        this.exprA = exprA;
        this.exprB = exprB;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, exprA, exprB);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, exprA, exprB);
    }

    @Override
    public boolean getBoolean() {
        boolean valueA = this.exprA.getBoolean();
        boolean valueB = this.exprB.getBoolean();
        boolean bl = this.exists = this.exprA.exists() && this.exprB.exists();
        return this.exists ? valueA == valueB : false;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

