/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.ShapeQuery;
import org.apache.lucene.geo.Line2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class XYShapeLineQuery
extends ShapeQuery {
    final XYLine[] lines;
    private final Line2D line2D;

    public XYShapeLineQuery(String field, ShapeField.QueryRelation queryRelation, XYLine ... lines) {
        super(field, queryRelation);
        if (queryRelation == ShapeField.QueryRelation.WITHIN) {
            throw new IllegalArgumentException("XYShapeLineQuery does not support " + (Object)((Object)ShapeField.QueryRelation.WITHIN) + " queries");
        }
        if (lines == null) {
            throw new IllegalArgumentException("lines must not be null");
        }
        if (lines.length == 0) {
            throw new IllegalArgumentException("lines must not be empty");
        }
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null) {
                throw new IllegalArgumentException("line[" + i + "] must not be null");
            }
            if (lines[i].minX > lines[i].maxX) {
                throw new IllegalArgumentException("XYShapeLineQuery: minX cannot be greater than maxX.");
            }
            if (!(lines[i].minY > lines[i].maxY)) continue;
            throw new IllegalArgumentException("XYShapeLineQuery: minY cannot be greater than maxY.");
        }
        this.lines = (XYLine[])lines.clone();
        this.line2D = Line2D.create(lines);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minLat = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])minTriangle, (int)minYOffset));
        double minLon = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])minTriangle, (int)minXOffset));
        double maxLat = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])maxTriangle, (int)maxYOffset));
        double maxLon = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])maxTriangle, (int)maxXOffset));
        return this.line2D.relate(minLat, maxLat, minLon, maxLon);
    }

    @Override
    protected boolean queryMatches(byte[] t, ShapeField.DecodedTriangle scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double alat = XYEncodingUtils.decode(scratchTriangle.aY);
        double alon = XYEncodingUtils.decode(scratchTriangle.aX);
        double blat = XYEncodingUtils.decode(scratchTriangle.bY);
        double blon = XYEncodingUtils.decode(scratchTriangle.bX);
        double clat = XYEncodingUtils.decode(scratchTriangle.cY);
        double clon = XYEncodingUtils.decode(scratchTriangle.cX);
        switch (queryRelation) {
            case INTERSECTS: {
                return this.line2D.relateTriangle(alon, alat, blon, blat, clon, clat) != PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            case WITHIN: {
                return this.line2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_INSIDE_QUERY;
            }
            case DISJOINT: {
                return this.line2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        throw new IllegalArgumentException("Unsupported query type :[" + (Object)((Object)queryRelation) + "]");
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("XYLine(").append(this.lines[0].toGeoJSON()).append(")");
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.lines, ((XYShapeLineQuery)((Object)o)).lines);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.lines);
        return hash;
    }
}

