/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov;

import com.drew.imaging.quicktime.QuickTimeHandler;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Metadata;
import com.drew.metadata.mov.QuickTimeDirectory;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.metadata.QuickTimeMetadataDirectory;
import java.io.IOException;

public abstract class QuickTimeMetadataHandler
extends QuickTimeHandler {
    public QuickTimeMetadataHandler(Metadata metadata) {
        super(metadata);
    }

    @NotNull
    protected QuickTimeDirectory getDirectory() {
        return new QuickTimeMetadataDirectory();
    }

    @Override
    protected boolean shouldAcceptAtom(@NotNull Atom atom) {
        return atom.type.equals("hdlr") || atom.type.equals("keys") || atom.type.equals("data");
    }

    @Override
    protected boolean shouldAcceptContainer(@NotNull Atom atom) {
        return atom.type.equals("ilst");
    }

    @Override
    protected QuickTimeHandler processAtom(@NotNull Atom atom, @Nullable byte[] payload) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (atom.type.equals("keys")) {
                this.processKeys(reader);
            } else if (atom.type.equals("data")) {
                this.processData(payload, reader);
            }
        }
        return this;
    }

    protected abstract void processKeys(@NotNull SequentialByteArrayReader var1) throws IOException;

    protected abstract void processData(@NotNull byte[] var1, @NotNull SequentialByteArrayReader var2) throws IOException;
}

