/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Equivalence;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Ticker;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.AbstractCache$StatsCounter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$NullListener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$OneWeigher;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheLoader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$EntryFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$EntrySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$KeySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$NullEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$Segment;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$Strength;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$ValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$Values;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.ReferenceEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalListener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalNotification;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.Weigher;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.primitives.Ints;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class LocalCache
extends AbstractMap
implements ConcurrentMap {
    static final Logger logger = Logger.getLogger(LocalCache.class.getName());
    final int segmentMask;
    final int segmentShift;
    final LocalCache$Segment[] segments;
    final int concurrencyLevel;
    final Equivalence keyEquivalence;
    final Equivalence valueEquivalence;
    final LocalCache$Strength keyStrength;
    final LocalCache$Strength valueStrength;
    final long maxWeight;
    final Weigher weigher;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final long refreshNanos;
    final Queue removalNotificationQueue;
    final RemovalListener removalListener;
    final Ticker ticker;
    final LocalCache$EntryFactory entryFactory;
    final AbstractCache$StatsCounter globalStatsCounter;
    @NullableDecl
    final CacheLoader defaultLoader;
    static final LocalCache$ValueReference UNSET = new LocalCache$1();
    static final Queue DISCARDING_QUEUE = new LocalCache$2();
    @MonotonicNonNullDecl
    Set keySet;
    @MonotonicNonNullDecl
    Collection values;
    @MonotonicNonNullDecl
    Set entrySet;

    LocalCache(CacheBuilder cacheBuilder, @NullableDecl CacheLoader cacheLoader) {
        int n;
        int n2;
        this.concurrencyLevel = Math.min(cacheBuilder.getConcurrencyLevel(), 65536);
        this.keyStrength = cacheBuilder.getKeyStrength();
        this.valueStrength = cacheBuilder.getValueStrength();
        this.keyEquivalence = cacheBuilder.getKeyEquivalence();
        this.valueEquivalence = cacheBuilder.getValueEquivalence();
        this.maxWeight = cacheBuilder.getMaximumWeight();
        this.weigher = cacheBuilder.getWeigher();
        this.expireAfterAccessNanos = cacheBuilder.getExpireAfterAccessNanos();
        this.expireAfterWriteNanos = cacheBuilder.getExpireAfterWriteNanos();
        this.refreshNanos = cacheBuilder.getRefreshNanos();
        this.removalListener = cacheBuilder.getRemovalListener();
        this.removalNotificationQueue = this.removalListener == CacheBuilder$NullListener.INSTANCE ? LocalCache.discardingQueue() : new ConcurrentLinkedQueue();
        this.ticker = cacheBuilder.getTicker(this.recordsTime());
        this.entryFactory = LocalCache$EntryFactory.getFactory(this.keyStrength, this.usesAccessEntries(), this.usesWriteEntries());
        this.globalStatsCounter = (AbstractCache$StatsCounter)cacheBuilder.getStatsCounterSupplier().get();
        this.defaultLoader = cacheLoader;
        int n3 = Math.min(cacheBuilder.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize() && !this.customWeigher()) {
            n3 = Math.min(n3, (int)this.maxWeight);
        }
        int n4 = 0;
        for (n2 = 1; !(n2 >= this.concurrencyLevel || this.evictsBySize() && (long)(n2 * 20) > this.maxWeight); n2 <<= 1) {
            ++n4;
        }
        this.segmentShift = 32 - n4;
        this.segmentMask = n2 - 1;
        this.segments = this.newSegmentArray(n2);
        int n5 = n3 / n2;
        if (n5 * n2 < n3) {
            ++n5;
        }
        for (n = 1; n < n5; n <<= 1) {
        }
        if (this.evictsBySize()) {
            long l = this.maxWeight / (long)n2 + 1L;
            long l2 = this.maxWeight % (long)n2;
            for (int i = 0; i < this.segments.length; ++i) {
                if ((long)i == l2) {
                    --l;
                }
                this.segments[i] = this.createSegment(n, l, (AbstractCache$StatsCounter)cacheBuilder.getStatsCounterSupplier().get());
            }
        } else {
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = this.createSegment(n, -1L, (AbstractCache$StatsCounter)cacheBuilder.getStatsCounterSupplier().get());
            }
        }
    }

    boolean evictsBySize() {
        return this.maxWeight >= 0L;
    }

    boolean customWeigher() {
        return this.weigher != CacheBuilder$OneWeigher.INSTANCE;
    }

    boolean expiresAfterWrite() {
        return this.expireAfterWriteNanos > 0L;
    }

    boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos > 0L;
    }

    boolean refreshes() {
        return this.refreshNanos > 0L;
    }

    boolean usesAccessQueue() {
        return this.expiresAfterAccess() || this.evictsBySize();
    }

    boolean usesWriteQueue() {
        return this.expiresAfterWrite();
    }

    boolean recordsWrite() {
        return this.expiresAfterWrite() || this.refreshes();
    }

    boolean recordsAccess() {
        return this.expiresAfterAccess();
    }

    boolean recordsTime() {
        return this.recordsWrite() || this.recordsAccess();
    }

    boolean usesWriteEntries() {
        return this.usesWriteQueue() || this.recordsWrite();
    }

    boolean usesAccessEntries() {
        return this.usesAccessQueue() || this.recordsAccess();
    }

    boolean usesKeyReferences() {
        return this.keyStrength != LocalCache$Strength.STRONG;
    }

    boolean usesValueReferences() {
        return this.valueStrength != LocalCache$Strength.STRONG;
    }

    static LocalCache$ValueReference unset() {
        return UNSET;
    }

    static ReferenceEntry nullEntry() {
        return LocalCache$NullEntry.INSTANCE;
    }

    static Queue discardingQueue() {
        return DISCARDING_QUEUE;
    }

    static int rehash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    int hash(@NullableDecl Object object) {
        int n = this.keyEquivalence.hash(object);
        return LocalCache.rehash(n);
    }

    void reclaimValue(LocalCache$ValueReference localCache$ValueReference) {
        ReferenceEntry referenceEntry = localCache$ValueReference.getEntry();
        int n = referenceEntry.getHash();
        this.segmentFor(n).reclaimValue(referenceEntry.getKey(), n, localCache$ValueReference);
    }

    void reclaimKey(ReferenceEntry referenceEntry) {
        int n = referenceEntry.getHash();
        this.segmentFor(n).reclaimKey(referenceEntry, n);
    }

    LocalCache$Segment segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    LocalCache$Segment createSegment(int n, long l, AbstractCache$StatsCounter abstractCache$StatsCounter) {
        return new LocalCache$Segment(this, n, l, abstractCache$StatsCounter);
    }

    @NullableDecl
    Object getLiveValue(ReferenceEntry referenceEntry, long l) {
        if (referenceEntry.getKey() == null) {
            return null;
        }
        Object object = referenceEntry.getValueReference().get();
        if (object == null) {
            return null;
        }
        if (this.isExpired(referenceEntry, l)) {
            return null;
        }
        return object;
    }

    boolean isExpired(ReferenceEntry referenceEntry, long l) {
        Preconditions.checkNotNull(referenceEntry);
        if (this.expiresAfterAccess() && l - referenceEntry.getAccessTime() >= this.expireAfterAccessNanos) {
            return true;
        }
        return this.expiresAfterWrite() && l - referenceEntry.getWriteTime() >= this.expireAfterWriteNanos;
    }

    static void connectAccessOrder(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
        referenceEntry.setNextInAccessQueue(referenceEntry2);
        referenceEntry2.setPreviousInAccessQueue(referenceEntry);
    }

    static void nullifyAccessOrder(ReferenceEntry referenceEntry) {
        ReferenceEntry referenceEntry2 = LocalCache.nullEntry();
        referenceEntry.setNextInAccessQueue(referenceEntry2);
        referenceEntry.setPreviousInAccessQueue(referenceEntry2);
    }

    static void connectWriteOrder(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
        referenceEntry.setNextInWriteQueue(referenceEntry2);
        referenceEntry2.setPreviousInWriteQueue(referenceEntry);
    }

    static void nullifyWriteOrder(ReferenceEntry referenceEntry) {
        ReferenceEntry referenceEntry2 = LocalCache.nullEntry();
        referenceEntry.setNextInWriteQueue(referenceEntry2);
        referenceEntry.setPreviousInWriteQueue(referenceEntry2);
    }

    void processPendingNotifications() {
        RemovalNotification removalNotification;
        while ((removalNotification = (RemovalNotification)this.removalNotificationQueue.poll()) != null) {
            try {
                this.removalListener.onRemoval(removalNotification);
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "Exception thrown by removal listener", throwable);
            }
        }
    }

    final LocalCache$Segment[] newSegmentArray(int n) {
        return new LocalCache$Segment[n];
    }

    @Override
    public boolean isEmpty() {
        int n;
        long l = 0L;
        LocalCache$Segment[] localCache$SegmentArray = this.segments;
        for (n = 0; n < localCache$SegmentArray.length; ++n) {
            if (localCache$SegmentArray[n].count != 0) {
                return false;
            }
            l += (long)localCache$SegmentArray[n].modCount;
        }
        if (l != 0L) {
            for (n = 0; n < localCache$SegmentArray.length; ++n) {
                if (localCache$SegmentArray[n].count != 0) {
                    return false;
                }
                l -= (long)localCache$SegmentArray[n].modCount;
            }
            if (l != 0L) {
                return false;
            }
        }
        return true;
    }

    long longSize() {
        LocalCache$Segment[] localCache$SegmentArray = this.segments;
        long l = 0L;
        for (int i = 0; i < localCache$SegmentArray.length; ++i) {
            l += (long)Math.max(0, localCache$SegmentArray[i].count);
        }
        return l;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.longSize());
    }

    @Override
    @NullableDecl
    public Object get(@NullableDecl Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hash(object);
        return this.segmentFor(n).get(object, n);
    }

    Object get(Object object, CacheLoader cacheLoader) {
        int n = this.hash(Preconditions.checkNotNull(object));
        return this.segmentFor(n).get(object, n, cacheLoader);
    }

    @Override
    @NullableDecl
    public Object getOrDefault(@NullableDecl Object object, @NullableDecl Object object2) {
        Object object3 = this.get(object);
        return object3 != null ? object3 : object2;
    }

    Object getOrLoad(Object object) {
        return this.get(object, this.defaultLoader);
    }

    @Override
    public boolean containsKey(@NullableDecl Object object) {
        if (object == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).containsKey(object, n);
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        if (object == null) {
            return false;
        }
        long l = this.ticker.read();
        LocalCache$Segment[] localCache$SegmentArray = this.segments;
        long l2 = -1L;
        for (int i = 0; i < 3; ++i) {
            long l3 = 0L;
            for (LocalCache$Segment localCache$Segment : localCache$SegmentArray) {
                int n = localCache$Segment.count;
                AtomicReferenceArray atomicReferenceArray = localCache$Segment.table;
                for (int j = 0; j < atomicReferenceArray.length(); ++j) {
                    for (ReferenceEntry referenceEntry = (ReferenceEntry)atomicReferenceArray.get(j); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                        Object object2 = localCache$Segment.getLiveValue(referenceEntry, l);
                        if (object2 == null || !this.valueEquivalence.equivalent(object, object2)) continue;
                        return true;
                    }
                }
                l3 += (long)localCache$Segment.modCount;
            }
            if (l3 == l2) break;
            l2 = l3;
        }
        return false;
    }

    @Override
    public Object put(Object object, Object object2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        int n = this.hash(object);
        return this.segmentFor(n).put(object, n, object2, false);
    }

    @Override
    public Object putIfAbsent(Object object, Object object2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        int n = this.hash(object);
        return this.segmentFor(n).put(object, n, object2, true);
    }

    @Override
    public Object compute(Object object, BiFunction biFunction) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(biFunction);
        int n = this.hash(object);
        return this.segmentFor(n).compute(object, n, biFunction);
    }

    @Override
    public Object computeIfAbsent(Object object, Function function) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(function);
        return this.compute(object, (T object2, U object3) -> object3 == null ? function.apply(object) : object3);
    }

    @Override
    public Object computeIfPresent(Object object3, BiFunction biFunction) {
        Preconditions.checkNotNull(object3);
        Preconditions.checkNotNull(biFunction);
        return this.compute(object3, (T object, U object2) -> object2 == null ? null : biFunction.apply(object, object2));
    }

    @Override
    public Object merge(Object object, Object object4, BiFunction biFunction) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object4);
        Preconditions.checkNotNull(biFunction);
        return this.compute(object, (T object2, U object3) -> object3 == null ? object4 : biFunction.apply(object3, object4));
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(@NullableDecl Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hash(object);
        return this.segmentFor(n).remove(object, n);
    }

    @Override
    public boolean remove(@NullableDecl Object object, @NullableDecl Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).remove(object, n, object2);
    }

    @Override
    public boolean replace(Object object, @NullableDecl Object object2, Object object3) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object3);
        if (object2 == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).replace(object, n, object2, object3);
    }

    @Override
    public Object replace(Object object, Object object2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        int n = this.hash(object);
        return this.segmentFor(n).replace(object, n, object2);
    }

    @Override
    public void clear() {
        for (LocalCache$Segment localCache$Segment : this.segments) {
            localCache$Segment.clear();
        }
    }

    @Override
    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new LocalCache$KeySet(this, this));
    }

    @Override
    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new LocalCache$Values(this, this));
    }

    @Override
    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new LocalCache$EntrySet(this, this));
    }

    private static ArrayList toArrayList(Collection collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        Iterators.addAll(arrayList, collection.iterator());
        return arrayList;
    }

    boolean removeIf(BiPredicate biPredicate) {
        Preconditions.checkNotNull(biPredicate);
        boolean bl = false;
        block0: for (Object e : this.keySet()) {
            Object object;
            while ((object = this.get(e)) != null && biPredicate.test(e, object)) {
                if (!this.remove(e, object)) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    static /* synthetic */ ArrayList access$200(Collection collection) {
        return LocalCache.toArrayList(collection);
    }
}

