/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class OutliersEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public OutliersEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values.length < 4) {
            throw new IOException("The outliers function requires 4 parameters");
        }
        Object dist = values[0];
        List vec = null;
        if (!(values[1] instanceof List)) {
            throw new IOException("The second parameter of the outliers function is the numeric array to be tested for outliers.");
        }
        vec = (List)values[1];
        double low = 0.0;
        if (!(values[2] instanceof Number)) {
            throw new IOException("The third parameter of the outliers function is a number for the low outlier threshold.");
        }
        low = ((Number)values[2]).doubleValue();
        double hi = 0.0;
        if (!(values[3] instanceof Number)) {
            throw new IOException("The fourth parameter of the outliers function is a number for the high outlier threshold");
        }
        hi = ((Number)values[3]).doubleValue();
        List<Tuple> tuples = null;
        if (values.length == 5) {
            if (!(values[4] instanceof List)) throw new IOException("The optional fifth parameter of the outliers function is an array of Tuples that are paired with the numeric array of values to be tested.");
            tuples = (List)values[4];
        } else {
            tuples = new ArrayList();
            for (int i = 0; i < vec.size(); ++i) {
                tuples.add(new Tuple(new HashMap()));
            }
        }
        ArrayList<Tuple> outliers = new ArrayList<Tuple>();
        if (dist instanceof IntegerDistribution) {
            IntegerDistribution d = (IntegerDistribution)dist;
            for (int i = 0; i < vec.size(); ++i) {
                Number n = (Number)vec.get(i);
                Tuple t = (Tuple)tuples.get(i);
                double cumProb = d.cumulativeProbability(n.intValue());
                if (low >= 0.0 && cumProb <= low) {
                    t.put("lowOutlierValue_d", n);
                    t.put("cumulativeProbablity_d", cumProb);
                    outliers.add(t);
                }
                if (!(hi >= 0.0) || !(cumProb >= hi)) continue;
                t.put("highOutlierValue_d", n);
                t.put("cumulativeProbablity_d", cumProb);
                outliers.add(t);
            }
            return outliers;
        }
        if (!(dist instanceof AbstractRealDistribution)) throw new IOException("The first parameter of the outliers function must be a real or integer probability distribution");
        AbstractRealDistribution d = (AbstractRealDistribution)dist;
        for (int i = 0; i < vec.size(); ++i) {
            Number n = (Number)vec.get(i);
            Tuple t = (Tuple)tuples.get(i);
            double cumProb = d.cumulativeProbability(n.doubleValue());
            if (low >= 0.0 && cumProb <= low) {
                t.put("lowOutlierValue_d", n);
                t.put("cumulativeProbablity_d", cumProb);
                outliers.add(t);
            }
            if (!(hi >= 0.0) || !(cumProb >= hi)) continue;
            t.put("highOutlierValue_d", n);
            t.put("cumulativeProbablity_d", cumProb);
            outliers.add(t);
        }
        return outliers;
    }
}

