/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.solr.common.MapWriter;

public interface ReflectMapWriter
extends MapWriter {
    default public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        for (Field field : this.getClass().getDeclaredFields()) {
            int modifiers;
            JsonProperty prop = field.getAnnotation(JsonProperty.class);
            if (prop == null || !Modifier.isPublic(modifiers = field.getModifiers()) || Modifier.isStatic(modifiers)) continue;
            String fname = prop.value().isEmpty() ? field.getName() : prop.value();
            try {
                if (field.getType() == Integer.TYPE) {
                    ew.put((CharSequence)fname, field.getInt(this));
                    continue;
                }
                if (field.getType() == Float.TYPE) {
                    ew.put((CharSequence)fname, field.getFloat(this));
                    continue;
                }
                if (field.getType() == Double.TYPE) {
                    ew.put((CharSequence)fname, field.getDouble(this));
                    continue;
                }
                if (field.getType() == Boolean.TYPE) {
                    ew.put((CharSequence)fname, field.getBoolean(this));
                    continue;
                }
                if (field.getType() == Long.TYPE) {
                    ew.put((CharSequence)fname, field.getLong(this));
                    continue;
                }
                ew.putIfNotNull((CharSequence)fname, field.get(this));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

