/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.common.SolrException;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrCacheBase;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.ConcurrentLRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastLRUCache<K, V>
extends SolrCacheBase
implements SolrCache<K, V>,
Accountable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FastLRUCache.class);
    public static final String MIN_SIZE_PARAM = "minSize";
    public static final String ACCEPTABLE_SIZE_PARAM = "acceptableSize";
    private List<ConcurrentLRUCache.Stats> statsList;
    private long warmupTime = 0L;
    private String description = "Concurrent LRU Cache";
    private ConcurrentLRUCache<K, V> cache;
    private int showItems = 0;
    private long maxRamBytes;
    private int maxSize;
    private int minSizeLimit;
    private int initialSize;
    private int acceptableSize;
    private boolean cleanupThread;
    private int maxIdleTimeSec;
    private long ramLowerWatermark;
    private MetricsMap cacheMap;
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();
    private SolrMetricsContext solrMetricsContext;

    @Override
    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        super.init(args, regenerator);
        String str = (String)args.get("size");
        this.maxSize = str == null ? 1024 : Integer.parseInt(str);
        str = (String)args.get(MIN_SIZE_PARAM);
        this.minSizeLimit = str == null ? (int)((double)this.maxSize * 0.9) : Integer.parseInt(str);
        this.checkAndAdjustLimits();
        str = (String)args.get(ACCEPTABLE_SIZE_PARAM);
        this.acceptableSize = str == null ? (int)((double)this.maxSize * 0.95) : Integer.parseInt(str);
        this.acceptableSize = Math.max(this.minSizeLimit, this.acceptableSize);
        str = (String)args.get("initialSize");
        this.initialSize = str == null ? this.maxSize : Integer.parseInt(str);
        str = (String)args.get("cleanupThread");
        this.cleanupThread = str == null ? false : Boolean.parseBoolean(str);
        str = (String)args.get("showItems");
        this.showItems = str == null ? 0 : Integer.parseInt(str);
        str = (String)args.get("maxIdleTime");
        this.maxIdleTimeSec = str == null ? -1 : Integer.parseInt(str);
        str = (String)args.get("maxRamMB");
        long maxRamMB = str == null ? -1L : (long)Double.parseDouble(str);
        long l = this.maxRamBytes = maxRamMB < 0L ? Long.MAX_VALUE : maxRamMB * 1024L * 1024L;
        if (this.maxRamBytes != Long.MAX_VALUE) {
            this.ramLowerWatermark = Math.round((double)this.maxRamBytes * 0.8);
            this.description = this.generateDescription(this.maxRamBytes, this.ramLowerWatermark, this.cleanupThread);
            this.cache = new ConcurrentLRUCache(this.ramLowerWatermark, this.maxRamBytes, this.cleanupThread, null, this.maxIdleTimeSec);
        } else {
            this.ramLowerWatermark = -1L;
            this.description = this.generateDescription(this.maxSize, this.initialSize, this.minSizeLimit, this.acceptableSize, this.cleanupThread);
            this.cache = new ConcurrentLRUCache(this.maxSize, this.minSizeLimit, this.acceptableSize, this.initialSize, this.cleanupThread, false, null, this.maxIdleTimeSec);
        }
        this.cache.setAlive(false);
        this.statsList = (List)persistence;
        if (this.statsList == null) {
            this.statsList = new CopyOnWriteArrayList<ConcurrentLRUCache.Stats>();
            this.statsList.add(new ConcurrentLRUCache.Stats());
        }
        this.statsList.add(this.cache.getStats());
        this.cacheMap = new MetricsMap((detailed, map) -> {
            if (this.cache != null) {
                ConcurrentLRUCache.Stats stats = this.cache.getStats();
                long lookups = stats.getCumulativeLookups();
                long hits = stats.getCumulativeHits();
                long inserts = stats.getCumulativePuts();
                long evictions = stats.getCumulativeEvictions();
                long idleEvictions = stats.getCumulativeIdleEvictions();
                long size = stats.getCurrentSize();
                long clookups = 0L;
                long chits = 0L;
                long cinserts = 0L;
                long cevictions = 0L;
                long cIdleEvictions = 0L;
                for (ConcurrentLRUCache.Stats statistiscs : this.statsList) {
                    clookups += statistiscs.getCumulativeLookups();
                    chits += statistiscs.getCumulativeHits();
                    cinserts += statistiscs.getCumulativePuts();
                    cevictions += statistiscs.getCumulativeEvictions();
                    cIdleEvictions += statistiscs.getCumulativeIdleEvictions();
                }
                map.put("lookups", lookups);
                map.put("hits", hits);
                map.put("hitratio", Float.valueOf(FastLRUCache.calcHitRatio(lookups, hits)));
                map.put("inserts", inserts);
                map.put("evictions", evictions);
                map.put("size", size);
                map.put("cleanupThread", this.cleanupThread);
                map.put("idleEvictions", idleEvictions);
                map.put("ramBytesUsed", this.ramBytesUsed());
                map.put("maxRamMB", this.getMaxRamMB());
                map.put("warmupTime", this.warmupTime);
                map.put("cumulative_lookups", clookups);
                map.put("cumulative_hits", chits);
                map.put("cumulative_hitratio", Float.valueOf(FastLRUCache.calcHitRatio(clookups, chits)));
                map.put("cumulative_inserts", cinserts);
                map.put("cumulative_evictions", cevictions);
                map.put("cumulative_idleEvictions", cIdleEvictions);
                if (detailed.booleanValue() && this.showItems != 0) {
                    Map<K, V> items = this.cache.getLatestAccessedItems(this.showItems == -1 ? Integer.MAX_VALUE : this.showItems);
                    for (Map.Entry<K, V> e : items.entrySet()) {
                        K k = e.getKey();
                        V v = e.getValue();
                        String ks = "item_" + k;
                        String vs = v.toString();
                        map.put(ks, vs);
                    }
                }
            }
        });
        return this.statsList;
    }

    protected String generateDescription() {
        if (this.maxRamBytes != Long.MAX_VALUE) {
            return this.generateDescription(this.maxRamBytes, this.ramLowerWatermark, this.cleanupThread);
        }
        return this.generateDescription(this.maxSize, this.initialSize, this.minSizeLimit, this.acceptableSize, this.cleanupThread);
    }

    protected String generateDescription(int limit, int initialSize, int minLimit, int acceptableLimit, boolean newThread) {
        String description = "Concurrent LRU Cache(maxSize=" + limit + ", initialSize=" + initialSize + ", minSize=" + minLimit + ", acceptableSize=" + acceptableLimit + ", cleanupThread=" + newThread;
        if (this.isAutowarmingOn()) {
            description = description + ", " + this.getAutowarmDescription();
        }
        description = description + ')';
        return description;
    }

    protected String generateDescription(long maxRamBytes, long ramLowerWatermark, boolean newThread) {
        String description = "Concurrent LRU Cache(ramMinSize=" + ramLowerWatermark + ", ramMaxSize=" + maxRamBytes + ", cleanupThread=" + newThread;
        if (this.isAutowarmingOn()) {
            description = description + ", " + this.getAutowarmDescription();
        }
        description = description + ')';
        return description;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public V put(K key, V value) {
        return this.cache.put(key, value);
    }

    @Override
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void setState(SolrCache.State state) {
        super.setState(state);
        this.cache.setAlive(state == SolrCache.State.LIVE);
    }

    @Override
    public void warm(SolrIndexSearcher searcher, SolrCache old) {
        if (this.regenerator == null) {
            return;
        }
        long warmingStartTime = System.nanoTime();
        FastLRUCache other = (FastLRUCache)old;
        if (this.isAutowarmingOn()) {
            int sz = this.autowarm.getWarmCount(other.size());
            Map<K, V> items = other.cache.getLatestAccessedItems(sz);
            Map.Entry[] itemsArr = new Map.Entry[items.size()];
            int counter = 0;
            for (Map.Entry<K, V> mapEntry : items.entrySet()) {
                itemsArr[counter++] = mapEntry;
            }
            for (int i = itemsArr.length - 1; i >= 0; --i) {
                try {
                    boolean continueRegen = this.regenerator.regenerateItem(searcher, this, old, itemsArr[i].getKey(), itemsArr[i].getValue());
                    if (continueRegen) continue;
                    break;
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Error during auto-warming of key:" + itemsArr[i].getKey()), (Throwable)e);
                }
            }
        }
        this.warmupTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - warmingStartTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public void close() throws Exception {
        SolrCache.super.close();
        this.statsList.get(0).add(this.cache.getStats());
        this.statsList.remove(this.cache.getStats());
        this.cache.destroy();
    }

    @Override
    public String getName() {
        return FastLRUCache.class.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        this.solrMetricsContext.gauge(this, this.cacheMap, true, scope, this.getCategory().toString());
    }

    MetricsMap getMetricsMap() {
        return this.cacheMap;
    }

    public String toString() {
        return this.name() + (this.cacheMap != null ? this.cacheMap.getValue().toString() : "");
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOfObject(this.cache) + RamUsageEstimator.sizeOfObject(this.statsList);
    }

    @Override
    public int getMaxSize() {
        return this.maxSize != Integer.MAX_VALUE ? this.maxSize : -1;
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize > 0 ? maxSize : Integer.MAX_VALUE;
        this.checkAndAdjustLimits();
        this.cache.setUpperWaterMark(maxSize);
        this.cache.setLowerWaterMark(this.minSizeLimit);
        this.description = this.generateDescription();
    }

    @Override
    public int getMaxRamMB() {
        return this.maxRamBytes != Long.MAX_VALUE ? (int)(this.maxRamBytes / 1024L / 1024L) : -1;
    }

    @Override
    public void setMaxRamMB(int maxRamMB) {
        this.maxRamBytes = maxRamMB < 0 ? Long.MAX_VALUE : (long)maxRamMB * 1024L * 1024L;
        this.ramLowerWatermark = maxRamMB < 0 ? Long.MIN_VALUE : Math.round((double)this.maxRamBytes * 0.8);
        this.cache.setRamUpperWatermark(this.maxRamBytes);
        this.cache.setRamLowerWatermark(this.ramLowerWatermark);
        this.description = this.generateDescription();
    }

    private void checkAndAdjustLimits() {
        if (this.minSizeLimit <= 0) {
            this.minSizeLimit = 1;
        }
        if (this.maxSize <= this.minSizeLimit) {
            if (this.maxSize > 1) {
                this.minSizeLimit = this.maxSize - 1;
            } else {
                this.maxSize = this.minSizeLimit + 1;
            }
        }
    }
}

