/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.util.DOMUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CacheConfig
implements MapSerializable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String nodeName;
    private Class<? extends SolrCache> clazz;
    private Map<String, String> args;
    private CacheRegenerator regenerator;
    private String cacheImpl;
    private Object[] persistence = new Object[1];
    private String regenImpl;

    public CacheConfig() {
    }

    public CacheConfig(Class<? extends SolrCache> clazz, Map<String, String> args, CacheRegenerator regenerator) {
        this.clazz = clazz;
        this.args = args;
        this.regenerator = regenerator;
    }

    public CacheRegenerator getRegenerator() {
        return this.regenerator;
    }

    public void setRegenerator(CacheRegenerator regenerator) {
        this.regenerator = regenerator;
    }

    public static Map<String, CacheConfig> getMultipleConfigs(SolrConfig solrConfig, String configPath) {
        NodeList nodes = (NodeList)solrConfig.evaluate(configPath, XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return new LinkedHashMap<String, CacheConfig>();
        }
        HashMap<String, CacheConfig> result = new HashMap<String, CacheConfig>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            CacheConfig config = CacheConfig.getConfig(solrConfig, nodes.item(i).getNodeName(), DOMUtil.toMap(nodes.item(i).getAttributes()), configPath);
            result.put(config.args.get("name"), config);
        }
        return result;
    }

    public static CacheConfig getConfig(SolrConfig solrConfig, String xpath) {
        Node node = solrConfig.getNode(xpath, false);
        if (node == null || !"true".equals(DOMUtil.getAttrOrDefault(node, "enabled", "true"))) {
            Map<String, String> m = solrConfig.getOverlay().getEditableSubProperties(xpath);
            if (m == null) {
                return null;
            }
            List parts = StrUtils.splitSmart((String)xpath, (char)'/');
            return CacheConfig.getConfig(solrConfig, (String)parts.get(parts.size() - 1), Collections.EMPTY_MAP, xpath);
        }
        return CacheConfig.getConfig(solrConfig, node.getNodeName(), DOMUtil.toMap(node.getAttributes()), xpath);
    }

    public static CacheConfig getConfig(SolrConfig solrConfig, String nodeName, Map<String, String> attrs, String xpath) {
        String nameAttr;
        Map<String, String> map;
        CacheConfig config = new CacheConfig();
        config.nodeName = nodeName;
        LinkedHashMap<String, String> attrsCopy = new LinkedHashMap<String, String>(attrs.size());
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            attrsCopy.put(e.getKey(), String.valueOf(e.getValue()));
        }
        attrs = attrsCopy;
        config.args = attrs;
        Map<String, String> map2 = map = xpath == null ? null : solrConfig.getOverlay().getEditableSubProperties(xpath);
        if (map != null) {
            HashMap<String, String> mapCopy = new HashMap<String, String>(config.args);
            for (Map.Entry<String, String> e : map.entrySet()) {
                mapCopy.put(e.getKey(), String.valueOf(e.getValue()));
            }
            config.args = mapCopy;
        }
        if ((nameAttr = config.args.get("name")) == null) {
            config.args.put("name", config.nodeName);
        }
        SolrResourceLoader loader = solrConfig.getResourceLoader();
        config.cacheImpl = config.args.get("class");
        if (config.cacheImpl == null) {
            config.cacheImpl = "solr.LRUCache";
        }
        config.regenImpl = config.args.get("regenerator");
        config.clazz = loader.findClass(config.cacheImpl, SolrCache.class);
        if (config.regenImpl != null) {
            config.regenerator = loader.newInstance(config.regenImpl, CacheRegenerator.class);
        }
        return config;
    }

    public SolrCache newInstance() {
        try {
            SolrCache cache = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.persistence[0] = cache.init(this.args, this.persistence[0], this.regenerator);
            return cache;
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (String)"Error instantiating cache", (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> toMap(Map<String, Object> map) {
        Map<String, Object> result = Collections.unmodifiableMap(this.args);
        return result;
    }

    public String getNodeName() {
        return this.nodeName;
    }
}

