/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.CurrencyFieldType;
import org.apache.solr.schema.ExchangeRateProvider;
import org.apache.solr.util.SafeXMLParsing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileExchangeRateProvider
implements ExchangeRateProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String PARAM_CURRENCY_CONFIG = "currencyConfig";
    private Map<String, Map<String, Double>> rates = new HashMap<String, Map<String, Double>>();
    private String currencyConfigFile;
    private ResourceLoader loader;

    @Override
    public double getExchangeRate(String sourceCurrencyCode, String targetCurrencyCode) {
        if (sourceCurrencyCode == null || targetCurrencyCode == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot get exchange rate; currency was null.");
        }
        if (sourceCurrencyCode.equals(targetCurrencyCode)) {
            return 1.0;
        }
        Double directRate = this.lookupRate(sourceCurrencyCode, targetCurrencyCode);
        if (directRate != null) {
            return directRate;
        }
        Double symmetricRate = this.lookupRate(targetCurrencyCode, sourceCurrencyCode);
        if (symmetricRate != null) {
            return 1.0 / symmetricRate;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No available conversion rate between " + sourceCurrencyCode + " to " + targetCurrencyCode);
    }

    private Double lookupRate(String sourceCurrencyCode, String targetCurrencyCode) {
        Map<String, Double> rhs = this.rates.get(sourceCurrencyCode);
        if (rhs != null) {
            return rhs.get(targetCurrencyCode);
        }
        return null;
    }

    private void addRate(Map<String, Map<String, Double>> ratesMap, String sourceCurrencyCode, String targetCurrencyCode, double rate) {
        Map<String, Double> rhs = ratesMap.get(sourceCurrencyCode);
        if (rhs == null) {
            rhs = new HashMap<String, Double>();
            ratesMap.put(sourceCurrencyCode, rhs);
        }
        rhs.put(targetCurrencyCode, rate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileExchangeRateProvider that = (FileExchangeRateProvider)o;
        return !(this.rates == null ? that.rates != null : !this.rates.equals(that.rates));
    }

    public int hashCode() {
        return this.rates != null ? this.rates.hashCode() : 0;
    }

    public String toString() {
        return "[" + this.getClass().getName() + " : " + this.rates.size() + " rates.]";
    }

    @Override
    public Set<String> listAvailableCurrencies() {
        HashSet<String> currencies = new HashSet<String>();
        for (String from : this.rates.keySet()) {
            currencies.add(from);
            for (String to : this.rates.get(from).keySet()) {
                currencies.add(to);
            }
        }
        return currencies;
    }

    @Override
    public boolean reload() throws SolrException {
        HashMap<String, Map<String, Double>> tmpRates = new HashMap<String, Map<String, Double>>();
        log.debug("Reloading exchange rates from file {}", (Object)this.currencyConfigFile);
        try {
            Document doc = SafeXMLParsing.parseConfigXML(log, this.loader, this.currencyConfigFile);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            NodeList nodes = (NodeList)xpath.evaluate("/currencyConfig/rates/rate", doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Double exchangeRate;
                Node rateNode = nodes.item(i);
                NamedNodeMap attributes = rateNode.getAttributes();
                Node from = attributes.getNamedItem("from");
                Node to = attributes.getNamedItem("to");
                Node rate = attributes.getNamedItem("rate");
                if (from == null || to == null || rate == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exchange rate missing attributes (required: from, to, rate) " + rateNode);
                }
                String fromCurrency = from.getNodeValue();
                String toCurrency = to.getNodeValue();
                if (null == CurrencyFieldType.getCurrency(fromCurrency)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Specified 'from' currency not supported in this JVM: " + fromCurrency);
                }
                if (null == CurrencyFieldType.getCurrency(toCurrency)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Specified 'to' currency not supported in this JVM: " + toCurrency);
                }
                try {
                    exchangeRate = Double.parseDouble(rate.getNodeValue());
                }
                catch (NumberFormatException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not parse exchange rate: " + rateNode, (Throwable)e);
                }
                this.addRate(tmpRates, fromCurrency, toCurrency, exchangeRate);
            }
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while parsing currency configuration file " + this.currencyConfigFile, (Throwable)e);
        }
        this.rates = tmpRates;
        return true;
    }

    @Override
    public void init(Map<String, String> params) throws SolrException {
        this.currencyConfigFile = params.get(PARAM_CURRENCY_CONFIG);
        if (this.currencyConfigFile == null) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Missing required configuration currencyConfig");
        }
        params.remove(PARAM_CURRENCY_CONFIG);
    }

    @Override
    public void inform(ResourceLoader loader) throws SolrException {
        if (loader == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Needs ResourceLoader in order to load config file");
        }
        this.loader = loader;
        this.reload();
    }
}

