/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.http.util.Args;
import org.apache.solr.security.JWTPrincipal;
import org.apache.solr.security.VerifiedUserRoles;

public class JWTPrincipalWithUserRoles
extends JWTPrincipal
implements VerifiedUserRoles {
    private final Set<String> roles;

    public JWTPrincipalWithUserRoles(String username, String token, Map<String, Object> claims, Set<String> roles) {
        super(username, token, claims);
        Args.notNull(roles, (String)"User roles");
        this.roles = roles;
    }

    @Override
    public Set<String> getVerifiedRoles() {
        return this.roles;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof JWTPrincipalWithUserRoles)) {
            return false;
        }
        JWTPrincipalWithUserRoles that = (JWTPrincipalWithUserRoles)o;
        return super.equals(o) && this.roles.equals(that.roles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.username, this.token, this.claims, this.roles);
    }

    @Override
    public String toString() {
        return "JWTPrincipalWithUserRoles{username='" + this.username + '\'' + ", token='*****" + '\'' + ", claims=" + this.claims + ", roles=" + this.roles + '}';
    }
}

