/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;

public class FiltersQParser
extends QParser {
    protected String getFiltersParamName() {
        return "param";
    }

    FiltersQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public final Query parse() throws SyntaxError {
        Map<Query, BooleanClause.Occur> clauses = this.clauses();
        this.exclude(clauses);
        int numClauses = 0;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        numClauses += this.addQuery(builder, clauses);
        return (numClauses += this.addFilters(builder, clauses)) > 0 ? this.wrapSubordinateClause((Query)builder.build()) : this.noClausesQuery();
    }

    protected Query wrapSubordinateClause(Query subordinate) throws SyntaxError {
        return subordinate;
    }

    protected Query noClausesQuery() throws SyntaxError {
        return new MatchAllDocsQuery();
    }

    protected int addQuery(BooleanQuery.Builder builder, Map<Query, BooleanClause.Occur> clauses) {
        int cnt = 0;
        for (Map.Entry<Query, BooleanClause.Occur> clause : clauses.entrySet()) {
            if (clause.getValue() != BooleanClause.Occur.MUST) continue;
            builder.add(clause.getKey(), clause.getValue());
            ++cnt;
        }
        return cnt;
    }

    protected int addFilters(BooleanQuery.Builder builder, Map<Query, BooleanClause.Occur> clauses) throws SyntaxError {
        int count = 0;
        for (Map.Entry<Query, BooleanClause.Occur> clause : clauses.entrySet()) {
            if (clause.getValue() != BooleanClause.Occur.FILTER) continue;
            builder.add(clause.getKey(), BooleanClause.Occur.FILTER);
            ++count;
        }
        return count;
    }

    protected void exclude(Map<Query, BooleanClause.Occur> clauses) {
        Map tagMap;
        HashSet<String> tagsToExclude = new HashSet<String>();
        String excludeTags = this.localParams.get("excludeTags");
        if (excludeTags != null) {
            tagsToExclude.addAll(StrUtils.splitSmart((String)excludeTags, (char)','));
        }
        if ((tagMap = (Map)this.req.getContext().get("tags")) != null && !tagMap.isEmpty() && !tagsToExclude.isEmpty()) {
            clauses.keySet().removeAll(this.excludeSet(tagMap, tagsToExclude));
        }
    }

    protected Map<Query, BooleanClause.Occur> clauses() throws SyntaxError {
        String[] params = this.localParams.getParams(this.getFiltersParamName());
        if (params != null && params.length == 0) {
            throw new SyntaxError("Local parameter " + this.getFiltersParamName() + " is not defined for " + this.stringIncludingLocalParams);
        }
        IdentityHashMap<Query, BooleanClause.Occur> clauses = new IdentityHashMap<Query, BooleanClause.Occur>();
        for (String filter : params == null ? new String[]{} : params) {
            if (filter == null || filter.length() == 0) {
                throw new SyntaxError("Filter '" + filter + "' has been picked in " + this.stringIncludingLocalParams);
            }
            QParser parser = this.subQuery(filter, null);
            Query query = parser.getQuery();
            clauses.put(query, BooleanClause.Occur.FILTER);
        }
        String queryText = this.localParams.get("v");
        if (queryText != null && queryText.length() > 0) {
            QParser parser = this.subQuery(queryText, null);
            clauses.put(parser.getQuery(), BooleanClause.Occur.MUST);
        }
        return clauses;
    }

    private Collection<?> excludeSet(Map tagMap, Set<String> tagsToExclude) {
        IdentityHashMap<Query, Boolean> excludeSet = new IdentityHashMap<Query, Boolean>();
        for (String excludeTag : tagsToExclude) {
            Object olst = tagMap.get(excludeTag);
            if (!(olst instanceof Collection)) continue;
            for (Object o : (Collection)olst) {
                if (!(o instanceof QParser)) continue;
                QParser qp = (QParser)o;
                try {
                    excludeSet.put(qp.getQuery(), Boolean.TRUE);
                }
                catch (SyntaxError syntaxError) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
                }
            }
        }
        return excludeSet.keySet();
    }
}

