/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.NaNFloatWriter;
import org.apache.solr.response.SolrQueryResponse;

class RubyWriter
extends NaNFloatWriter {
    @Override
    protected String getNaN() {
        return "(0.0/0.0)";
    }

    @Override
    protected String getInf() {
        return "(1.0/0.0)";
    }

    public RubyWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
    }

    public void writeNull(String name) throws IOException {
        this.writer.write("nil");
    }

    public void writeKey(String fname, boolean needsEscaping) throws IOException {
        this.writeStr(null, fname, needsEscaping);
        this.writer.write('=');
        this.writer.write('>');
    }

    public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        this.writer.write('\'');
        if (needsEscaping) {
            for (int i = 0; i < val.length(); ++i) {
                char ch = val.charAt(i);
                if (ch == '\'' || ch == '\\') {
                    this.writer.write('\\');
                }
                this.writer.write(ch);
            }
        } else {
            this.writer.write(val);
        }
        this.writer.write('\'');
    }
}

