/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.solr.analytics.AnalyticsRequestManager;
import org.apache.solr.analytics.stream.AnalyticsShardResponseParser;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;

public class AnalyticsShardRequestManager {
    private final SolrParams params;
    protected transient CloudSolrClient cloudSolrClient;
    protected transient List<String> replicaUrls;
    private final transient AnalyticsRequestManager manager;

    public AnalyticsShardRequestManager(SolrParams params, AnalyticsRequestManager manager) {
        this.manager = manager;
        this.params = AnalyticsShardRequestManager.loadParams(params, manager.analyticsRequest);
    }

    public void sendRequests(String collection, String zkHost) throws IOException {
        this.replicaUrls = new ArrayList<String>();
        this.cloudSolrClient = new CloudSolrClient.Builder(Collections.singletonList(zkHost), Optional.empty()).build();
        try {
            this.cloudSolrClient.connect();
            this.pickShards(collection);
            this.streamFromShards();
        }
        finally {
            this.cloudSolrClient.close();
        }
    }

    protected void pickShards(String collection) throws IOException {
        try {
            Slice[] slices;
            ZkStateReader zkStateReader = this.cloudSolrClient.getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Set liveNodes = clusterState.getLiveNodes();
            for (Slice slice : slices = clusterState.getCollection(collection).getActiveSlicesArr()) {
                Collection replicas = slice.getReplicas();
                ArrayList<Replica> shuffler = new ArrayList<Replica>();
                for (Replica replica : replicas) {
                    if (replica.getState() != Replica.State.ACTIVE || !liveNodes.contains(replica.getNodeName())) continue;
                    shuffler.add(replica);
                }
                Collections.shuffle(shuffler, new Random());
                Replica rep = (Replica)shuffler.get(0);
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps((ZkNodeProps)rep);
                String url = zkProps.getCoreUrl();
                this.replicaUrls.add(url);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void streamFromShards() throws IOException {
        ExecutorService service = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("SolrAnalyticsStream"));
        ArrayList<Future<SolrException>> futures = new ArrayList<Future<SolrException>>();
        ArrayList<AnalyticsShardRequester> openers = new ArrayList<AnalyticsShardRequester>();
        for (String string : this.replicaUrls) {
            AnalyticsShardRequester opener = new AnalyticsShardRequester(string);
            openers.add(opener);
            Future<SolrException> future = service.submit(opener);
            futures.add(future);
        }
        try {
            for (Future future : futures) {
                SolrException e = (SolrException)((Object)future.get());
                if (e == null) continue;
                throw e;
            }
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
        catch (ExecutionException e1) {
            throw new RuntimeException(e1);
        }
        finally {
            service.shutdown();
            for (AnalyticsShardRequester opener : openers) {
                opener.close();
            }
        }
    }

    private static SolrParams loadParams(SolrParams paramsIn, String analyticsRequest) {
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.add("qt", new String[]{"/analytics"});
        solrParams.add("wt", new String[]{"analytics_shard_stream"});
        solrParams.add("q", new String[]{paramsIn.get("q")});
        solrParams.add("fq", paramsIn.getParams("fq"));
        solrParams.add("analytics", new String[]{analyticsRequest});
        return solrParams;
    }

    protected class AnalyticsShardRequester
    implements Callable<SolrException> {
        private String baseUrl;
        HttpSolrClient client;

        public AnalyticsShardRequester(String baseUrl) {
            this.baseUrl = baseUrl;
            this.client = null;
        }

        @Override
        public SolrException call() throws Exception {
            this.client = new HttpSolrClient.Builder(this.baseUrl).build();
            QueryRequest query = new QueryRequest(AnalyticsShardRequestManager.this.params);
            query.setPath("/analytics");
            query.setResponseParser((ResponseParser)new AnalyticsShardResponseParser(AnalyticsShardRequestManager.this.manager));
            query.setMethod(SolrRequest.METHOD.POST);
            NamedList exception = this.client.request((SolrRequest)query);
            if (exception.size() > 0) {
                return (SolrException)((Object)exception.getVal(0));
            }
            return null;
        }

        public void close() throws IOException {
            if (this.client != null) {
                this.client.close();
            }
        }
    }
}

