/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.MaxCollector;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;

class StringMaxFunction
extends StringValue.AbstractStringValue
implements ReductionFunction {
    private MaxCollector.StringMaxCollector collector;
    public static final String name = "max";
    private final String exprStr;

    public StringMaxFunction(StringValueStream param) {
        this.collector = new MaxCollector.StringMaxCollector(param);
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    @Override
    public String getString() {
        return this.collector.exists() ? this.collector.max() : null;
    }

    @Override
    public boolean exists() {
        return this.collector.exists();
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (MaxCollector.StringMaxCollector)sync.apply(this.collector);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

