/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.common.SolrException;

class LongIfFunction
extends LongValue.AbstractLongValue {
    private final BooleanValue ifExpr;
    private final LongValue thenExpr;
    private final LongValue elseExpr;
    public static final String name = "if";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;

    public LongIfFunction(BooleanValue ifExpr, LongValue thenExpr, LongValue elseExpr) throws SolrException {
        this.ifExpr = ifExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, ifExpr, thenExpr, elseExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
    }

    @Override
    public long getLong() {
        this.exists = false;
        long value = 0L;
        boolean ifValue = this.ifExpr.getBoolean();
        if (this.ifExpr.exists()) {
            if (ifValue) {
                value = this.thenExpr.getLong();
                this.exists = this.thenExpr.exists();
            } else {
                value = this.elseExpr.getLong();
                this.exists = this.elseExpr.exists();
            }
        }
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

