/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.engine.util.DateUtils;
import org.restlet.representation.RepresentationInfo;

public final class Conditions {
    private volatile List<Tag> match;
    private volatile Date modifiedSince;
    private volatile List<Tag> noneMatch;
    private volatile Date rangeDate;
    private volatile Tag rangeTag;
    private volatile Date unmodifiedSince;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tag> getMatch() {
        List<Tag> m = this.match;
        if (m == null) {
            Conditions conditions = this;
            synchronized (conditions) {
                m = this.match;
                if (m == null) {
                    this.match = m = new ArrayList<Tag>();
                }
            }
        }
        return m;
    }

    public Date getModifiedSince() {
        return this.modifiedSince;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tag> getNoneMatch() {
        List<Tag> n = this.noneMatch;
        if (n == null) {
            Conditions conditions = this;
            synchronized (conditions) {
                n = this.noneMatch;
                if (n == null) {
                    this.noneMatch = n = new ArrayList<Tag>();
                }
            }
        }
        return n;
    }

    public Date getRangeDate() {
        return this.rangeDate;
    }

    public Status getRangeStatus(RepresentationInfo representationInfo) {
        return this.getRangeStatus(representationInfo == null ? null : representationInfo.getTag(), representationInfo == null ? null : representationInfo.getModificationDate());
    }

    public Status getRangeStatus(Tag tag, Date modificationDate) {
        Status result = Status.CLIENT_ERROR_PRECONDITION_FAILED;
        if (this.getRangeTag() != null) {
            boolean all = this.getRangeTag().equals(Tag.ALL);
            if (tag != null && (all || this.getRangeTag().equals(tag))) {
                result = Status.SUCCESS_OK;
            }
        } else if (this.getRangeDate() != null && this.getRangeDate().equals(modificationDate)) {
            result = Status.SUCCESS_OK;
        }
        return result;
    }

    public Tag getRangeTag() {
        return this.rangeTag;
    }

    public Status getStatus(Method method, boolean entityExists, Tag tag, Date modificationDate) {
        boolean matched;
        Status result = null;
        if (this.match != null && !this.match.isEmpty()) {
            matched = false;
            boolean failed = false;
            boolean all = this.getMatch().size() > 0 && this.getMatch().get(0).equals(Tag.ALL);
            String statusMessage = null;
            if (entityExists) {
                if (!all && tag != null) {
                    Iterator<Tag> iter = this.getMatch().iterator();
                    while (!matched && iter.hasNext()) {
                        Tag matchTag = iter.next();
                        matched = matchTag.equals(tag, false);
                    }
                } else {
                    matched = all;
                }
            } else {
                failed = all;
                statusMessage = "A non existing resource can't match any tag.";
            }
            boolean bl = failed = failed || !matched;
            if (failed) {
                result = Status.CLIENT_ERROR_PRECONDITION_FAILED;
                if (statusMessage != null) {
                    result = new Status(result, statusMessage);
                }
            }
        }
        if (result == null && this.noneMatch != null && !this.noneMatch.isEmpty()) {
            matched = false;
            if (entityExists) {
                if (tag != null) {
                    Iterator<Tag> iter = this.getNoneMatch().iterator();
                    while (!matched && iter.hasNext()) {
                        Tag noneMatchTag = iter.next();
                        matched = noneMatchTag.equals(tag, Method.GET.equals(method) || Method.HEAD.equals(method));
                    }
                    if (matched) {
                        Date modifiedSince = this.getModifiedSince();
                        boolean isModifiedSince = modifiedSince != null && (DateUtils.after(new Date(), modifiedSince) || modificationDate == null || DateUtils.after(modifiedSince, modificationDate));
                        matched = !isModifiedSince;
                    }
                } else {
                    boolean bl = matched = this.getNoneMatch().size() > 0 && this.getNoneMatch().get(0).equals(Tag.ALL);
                }
            }
            if (matched) {
                result = Method.GET.equals(method) || Method.HEAD.equals(method) ? Status.REDIRECTION_NOT_MODIFIED : Status.CLIENT_ERROR_PRECONDITION_FAILED;
            }
        }
        if (result == null && this.getModifiedSince() != null) {
            boolean isModifiedSince;
            Date modifiedSince = this.getModifiedSince();
            boolean bl = isModifiedSince = DateUtils.after(new Date(), modifiedSince) || modificationDate == null || DateUtils.after(modifiedSince, modificationDate);
            if (!isModifiedSince) {
                result = Method.GET.equals(method) || Method.HEAD.equals(method) ? Status.REDIRECTION_NOT_MODIFIED : Status.CLIENT_ERROR_PRECONDITION_FAILED;
            }
        }
        if (result == null && this.getUnmodifiedSince() != null) {
            boolean isUnModifiedSince;
            Date unModifiedSince = this.getUnmodifiedSince();
            boolean bl = isUnModifiedSince = unModifiedSince == null || modificationDate == null || !DateUtils.before(modificationDate, unModifiedSince);
            if (!isUnModifiedSince) {
                result = Status.CLIENT_ERROR_PRECONDITION_FAILED;
            }
        }
        return result;
    }

    public Status getStatus(Method method, RepresentationInfo representationInfo) {
        return this.getStatus(method, representationInfo != null, representationInfo == null ? null : representationInfo.getTag(), representationInfo == null ? null : representationInfo.getModificationDate());
    }

    public Date getUnmodifiedSince() {
        return this.unmodifiedSince;
    }

    public boolean hasSome() {
        return this.match != null && !this.match.isEmpty() || this.noneMatch != null && !this.noneMatch.isEmpty() || this.getModifiedSince() != null || this.getUnmodifiedSince() != null;
    }

    public boolean hasSomeRange() {
        return this.getRangeTag() != null || this.getRangeDate() != null;
    }

    public void setMatch(List<Tag> tags) {
        this.match = tags;
    }

    public void setModifiedSince(Date date) {
        this.modifiedSince = DateUtils.unmodifiable(date);
    }

    public void setNoneMatch(List<Tag> tags) {
        this.noneMatch = tags;
    }

    public void setRangeDate(Date rangeDate) {
        this.rangeDate = rangeDate;
    }

    public void setRangeTag(Tag rangeTag) {
        this.rangeTag = rangeTag;
    }

    public void setUnmodifiedSince(Date date) {
        this.unmodifiedSince = DateUtils.unmodifiable(date);
    }
}

