/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractContainerBox;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.MemoryDataSourceImpl;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class MetaBox
extends AbstractContainerBox {
    public static final String TYPE = "meta";
    private boolean isFullBox = true;
    private int version;
    private int flags;

    public MetaBox() {
        super(TYPE);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    protected final long parseVersionAndFlags(ByteBuffer content) {
        this.version = IsoTypeReader.readUInt8(content);
        this.flags = IsoTypeReader.readUInt24(content);
        return 4L;
    }

    protected final void writeVersionAndFlags(ByteBuffer bb) {
        IsoTypeWriter.writeUInt8(bb, this.version);
        IsoTypeWriter.writeUInt24(bb, this.flags);
    }

    public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(CastUtils.l2i(contentSize));
        dataSource.read(bb);
        bb.position(4);
        String isHdlr = IsoTypeReader.read4cc(bb);
        if ("hdlr".equals(isHdlr)) {
            this.isFullBox = false;
            this.initContainer(new MemoryDataSourceImpl((ByteBuffer)bb.rewind()), contentSize, boxParser);
        } else {
            this.isFullBox = true;
            this.parseVersionAndFlags((ByteBuffer)bb.rewind());
            this.initContainer(new MemoryDataSourceImpl(bb), contentSize - 4L, boxParser);
        }
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        if (this.isFullBox) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            this.writeVersionAndFlags(bb);
            writableByteChannel.write((ByteBuffer)bb.rewind());
        }
        this.writeContainer(writableByteChannel);
    }

    public long getSize() {
        long s = this.getContainerSize();
        long t = 0L;
        if (this.isFullBox) {
            t += 4L;
        }
        return s + t + (long)(this.largeBox || s + t >= 0x100000000L ? 16 : 8);
    }
}

