/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZooKeeper;
import org.apache.solr.common.cloud.ZkCredentialsProvider;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZkClientConnectionStrategy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile ZkCredentialsProvider zkCredentialsToAddAutomatically;
    private volatile boolean zkCredentialsToAddAutomaticallyUsed = false;
    private List<DisconnectedListener> disconnectedListeners = new ArrayList<DisconnectedListener>();
    private List<ConnectedListener> connectedListeners = new ArrayList<ConnectedListener>();

    public abstract void connect(String var1, int var2, Watcher var3, ZkUpdate var4) throws IOException, InterruptedException, TimeoutException;

    public abstract void reconnect(String var1, int var2, Watcher var3, ZkUpdate var4) throws IOException, InterruptedException, TimeoutException;

    public synchronized void disconnected() {
        for (DisconnectedListener listener : this.disconnectedListeners) {
            try {
                listener.disconnected();
            }
            catch (Exception e) {
                SolrException.log(log, "", e);
            }
        }
    }

    public synchronized void connected() {
        for (ConnectedListener listener : this.connectedListeners) {
            try {
                listener.connected();
            }
            catch (Exception e) {
                SolrException.log(log, "", e);
            }
        }
    }

    public synchronized void addDisconnectedListener(DisconnectedListener listener) {
        this.disconnectedListeners.add(listener);
    }

    public synchronized void addConnectedListener(ConnectedListener listener) {
        this.connectedListeners.add(listener);
    }

    public void setZkCredentialsToAddAutomatically(ZkCredentialsProvider zkCredentialsToAddAutomatically) {
        if (this.zkCredentialsToAddAutomaticallyUsed || zkCredentialsToAddAutomatically == null) {
            throw new RuntimeException("Cannot change zkCredentialsToAddAutomatically after it has been (connect or reconnect was called) used or to null");
        }
        this.zkCredentialsToAddAutomatically = zkCredentialsToAddAutomatically;
    }

    public boolean hasZkCredentialsToAddAutomatically() {
        return this.zkCredentialsToAddAutomatically != null;
    }

    public ZkCredentialsProvider getZkCredentialsToAddAutomatically() {
        return this.zkCredentialsToAddAutomatically;
    }

    protected SolrZooKeeper createSolrZooKeeper(String serverAddress, int zkClientTimeout, Watcher watcher) throws IOException {
        SolrZooKeeper result = new SolrZooKeeper(serverAddress, zkClientTimeout, watcher);
        this.zkCredentialsToAddAutomaticallyUsed = true;
        for (ZkCredentialsProvider.ZkCredentials zkCredentials : this.zkCredentialsToAddAutomatically.getCredentials()) {
            result.addAuthInfo(zkCredentials.getScheme(), zkCredentials.getAuth());
        }
        return result;
    }

    public static interface ZkUpdate {
        public void update(SolrZooKeeper var1) throws InterruptedException, TimeoutException, IOException;
    }

    public static interface ConnectedListener {
        public void connected();
    }

    public static interface DisconnectedListener {
        public void disconnected();
    }
}

