/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.MoreObjects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LoadingCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashMultimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscribe;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscriber;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SubscriberRegistry$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SubscriberRegistry$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SubscriberRegistry$MethodIdentifier;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeToken;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.j2objc.annotations.Weak;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;

final class SubscriberRegistry {
    private final ConcurrentMap subscribers = Maps.newConcurrentMap();
    @Weak
    private final EventBus bus;
    private static final LoadingCache subscriberMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new SubscriberRegistry$1());
    private static final LoadingCache flattenHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new SubscriberRegistry$2());

    SubscriberRegistry(EventBus eventBus) {
        this.bus = (EventBus)Preconditions.checkNotNull(eventBus);
    }

    void register(Object object) {
        Multimap multimap = this.findAllSubscribers(object);
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            Class clazz = (Class)entry.getKey();
            Collection collection = (Collection)entry.getValue();
            CopyOnWriteArraySet copyOnWriteArraySet = (CopyOnWriteArraySet)this.subscribers.get(clazz);
            if (copyOnWriteArraySet == null) {
                CopyOnWriteArraySet copyOnWriteArraySet2 = new CopyOnWriteArraySet();
                copyOnWriteArraySet = (CopyOnWriteArraySet)MoreObjects.firstNonNull(this.subscribers.putIfAbsent(clazz, copyOnWriteArraySet2), copyOnWriteArraySet2);
            }
            copyOnWriteArraySet.addAll(collection);
        }
    }

    Iterator getSubscribers(Object object) {
        ImmutableSet immutableSet = SubscriberRegistry.flattenHierarchy(object.getClass());
        ArrayList arrayList = Lists.newArrayListWithCapacity(immutableSet.size());
        for (Class clazz : immutableSet) {
            CopyOnWriteArraySet copyOnWriteArraySet = (CopyOnWriteArraySet)this.subscribers.get(clazz);
            if (copyOnWriteArraySet == null) continue;
            arrayList.add(copyOnWriteArraySet.iterator());
        }
        return Iterators.concat(arrayList.iterator());
    }

    private Multimap findAllSubscribers(Object object) {
        HashMultimap hashMultimap = HashMultimap.create();
        Class<?> clazz = object.getClass();
        for (Method method : SubscriberRegistry.getAnnotatedMethods(clazz)) {
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz2 = classArray[0];
            hashMultimap.put(clazz2, Subscriber.create(this.bus, object, method));
        }
        return hashMultimap;
    }

    private static ImmutableList getAnnotatedMethods(Class clazz) {
        return (ImmutableList)subscriberMethodsCache.getUnchecked(clazz);
    }

    private static ImmutableList getAnnotatedMethodsNotCached(Class clazz) {
        Set set = TypeToken.of(clazz).getTypes().rawTypes();
        HashMap hashMap = Maps.newHashMap();
        for (Class clazz2 : set) {
            for (Method method : clazz2.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Subscribe.class) || method.isSynthetic()) continue;
                Class<?>[] classArray = method.getParameterTypes();
                Preconditions.checkArgument(classArray.length == 1, "Method %s has @Subscribe annotation but has %s parameters.Subscriber methods must have exactly 1 parameter.", (Object)method, classArray.length);
                SubscriberRegistry$MethodIdentifier subscriberRegistry$MethodIdentifier = new SubscriberRegistry$MethodIdentifier(method);
                if (hashMap.containsKey(subscriberRegistry$MethodIdentifier)) continue;
                hashMap.put(subscriberRegistry$MethodIdentifier, method);
            }
        }
        return ImmutableList.copyOf(hashMap.values());
    }

    static ImmutableSet flattenHierarchy(Class clazz) {
        try {
            return (ImmutableSet)flattenHierarchyCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            throw Throwables.propagate(uncheckedExecutionException.getCause());
        }
    }

    static /* synthetic */ ImmutableList access$000(Class clazz) {
        return SubscriberRegistry.getAnnotatedMethodsNotCached(clazz);
    }
}

