/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.analytics.AnalyticsRequestParser;
import org.apache.solr.analytics.util.OldAnalyticsParams;
import org.apache.solr.common.params.SolrParams;

public class OldAnalyticsRequestConverter
implements OldAnalyticsParams {
    private static final Pattern oldExprPattern = Pattern.compile("^(?:o|olap)\\.([^\\.]+)\\.(?:s|stat|statistic)\\.([^\\.]+)$", 2);
    private static final Pattern oldFieldFacetPattern = Pattern.compile("^(?:o|olap)\\.([^\\.]+)\\.(?:ff|fieldfacet)$", 2);
    private static final Pattern oldFieldFacetParamPattern = Pattern.compile("^(?:o|olap)\\.([^\\.]+)\\.(?:ff|fieldfacet)\\.([^\\.]+)\\.(" + OldAnalyticsParams.FieldFacetParamParser.regexParamList + ")$", 2);
    private static final Pattern oldRangeFacetParamPattern = Pattern.compile("^(?:o|olap)\\.([^\\.]+)\\.(?:rf|rangefacet)\\.([^\\.]+)\\.(" + OldAnalyticsParams.RangeFacetParamParser.regexParamList + ")$", 2);
    private static final Pattern oldQueryFacetParamPattern = Pattern.compile("^(?:o|olap)\\.([^\\.]+)\\.(?:qf|queryfacet)\\.([^\\.]+)\\.(q|query)$", 2);

    public static AnalyticsRequestParser.AnalyticsRequest convert(SolrParams params) {
        AnalyticsRequestParser.AnalyticsRequest request = new AnalyticsRequestParser.AnalyticsRequest();
        request.expressions = new HashMap<String, String>();
        request.groupings = new HashMap<String, AnalyticsRequestParser.AnalyticsGroupingRequest>();
        Iterator paramsIterator = params.getParameterNamesIterator();
        while (paramsIterator.hasNext()) {
            String param = (String)paramsIterator.next();
            CharSequence paramSequence = param.subSequence(0, param.length());
            OldAnalyticsRequestConverter.parseParam(request, param, paramSequence, params);
        }
        return request;
    }

    private static void parseParam(AnalyticsRequestParser.AnalyticsRequest request, String param, CharSequence paramSequence, SolrParams params) {
        Matcher m = oldExprPattern.matcher(paramSequence);
        if (m.matches()) {
            OldAnalyticsRequestConverter.addExpression(request, m.group(1), m.group(2), params.get(param));
            return;
        }
        m = oldFieldFacetPattern.matcher(paramSequence);
        if (m.matches()) {
            OldAnalyticsRequestConverter.addFieldFacets(request, m.group(1), params.getParams(param));
            return;
        }
        m = oldFieldFacetParamPattern.matcher(paramSequence);
        if (m.matches()) {
            OldAnalyticsRequestConverter.setFieldFacetParam(request, m.group(1), m.group(2), m.group(3), params.getParams(param));
            return;
        }
        m = oldFieldFacetParamPattern.matcher(paramSequence);
        if (m.matches()) {
            OldAnalyticsRequestConverter.setFieldFacetParam(request, m.group(1), m.group(2), m.group(3), params.getParams(param));
            return;
        }
        m = oldRangeFacetParamPattern.matcher(paramSequence);
        if (m.matches()) {
            OldAnalyticsRequestConverter.setRangeFacetParam(request, m.group(1), m.group(2), m.group(3), params.getParams(param));
            return;
        }
        m = oldQueryFacetParamPattern.matcher(paramSequence);
        if (m.matches()) {
            OldAnalyticsRequestConverter.setQueryFacetParam(request, m.group(1), m.group(2), m.group(3), params.getParams(param));
            return;
        }
    }

    private static AnalyticsRequestParser.AnalyticsGroupingRequest getGrouping(AnalyticsRequestParser.AnalyticsRequest request, String name) {
        AnalyticsRequestParser.AnalyticsGroupingRequest grouping = request.groupings.get(name);
        if (grouping == null) {
            grouping = new AnalyticsRequestParser.AnalyticsGroupingRequest();
            grouping.expressions = new HashMap<String, String>();
            grouping.facets = new HashMap<String, AnalyticsRequestParser.AnalyticsFacetRequest>();
            request.groupings.put(name, grouping);
        }
        return grouping;
    }

    private static void addFieldFacets(AnalyticsRequestParser.AnalyticsRequest request, String groupingName, String[] params) {
        AnalyticsRequestParser.AnalyticsGroupingRequest grouping = OldAnalyticsRequestConverter.getGrouping(request, groupingName);
        for (String param : params) {
            if (grouping.facets.containsKey(param)) continue;
            AnalyticsRequestParser.AnalyticsValueFacetRequest fieldFacet = new AnalyticsRequestParser.AnalyticsValueFacetRequest();
            fieldFacet.expression = param;
            grouping.facets.put(param, fieldFacet);
        }
    }

    private static void setFieldFacetParam(AnalyticsRequestParser.AnalyticsRequest request, String groupingName, String field, String paramType, String[] params) {
        AnalyticsRequestParser.AnalyticsGroupingRequest grouping = OldAnalyticsRequestConverter.getGrouping(request, groupingName);
        AnalyticsRequestParser.AnalyticsValueFacetRequest fieldFacet = (AnalyticsRequestParser.AnalyticsValueFacetRequest)grouping.facets.get(field);
        if (fieldFacet == null) {
            fieldFacet = new AnalyticsRequestParser.AnalyticsValueFacetRequest();
            fieldFacet.expression = field;
            grouping.facets.put(field, fieldFacet);
        }
        OldAnalyticsParams.FieldFacetParamParser.applyParam(fieldFacet, paramType, params[0]);
    }

    private static void setRangeFacetParam(AnalyticsRequestParser.AnalyticsRequest request, String groupingName, String field, String paramType, String[] params) {
        AnalyticsRequestParser.AnalyticsGroupingRequest grouping = OldAnalyticsRequestConverter.getGrouping(request, groupingName);
        AnalyticsRequestParser.AnalyticsRangeFacetRequest rangeFacet = (AnalyticsRequestParser.AnalyticsRangeFacetRequest)grouping.facets.get(field);
        if (rangeFacet == null) {
            rangeFacet = new AnalyticsRequestParser.AnalyticsRangeFacetRequest();
            rangeFacet.field = field;
            grouping.facets.put(field, rangeFacet);
        }
        OldAnalyticsParams.RangeFacetParamParser.applyParam(rangeFacet, paramType, params);
    }

    private static void setQueryFacetParam(AnalyticsRequestParser.AnalyticsRequest request, String groupingName, String facetName, String paramType, String[] params) {
        AnalyticsRequestParser.AnalyticsGroupingRequest grouping = OldAnalyticsRequestConverter.getGrouping(request, groupingName);
        AnalyticsRequestParser.AnalyticsQueryFacetRequest queryFacet = new AnalyticsRequestParser.AnalyticsQueryFacetRequest();
        queryFacet.queries = new HashMap<String, String>();
        if (paramType.equals("query") || paramType.equals("q")) {
            for (String param : params) {
                queryFacet.queries.put(param, param);
            }
        }
        grouping.facets.put(facetName, queryFacet);
    }

    private static void addExpression(AnalyticsRequestParser.AnalyticsRequest request, String groupingName, String expressionName, String expression) {
        request.expressions.put(groupingName + expressionName, expression);
        OldAnalyticsRequestConverter.getGrouping((AnalyticsRequestParser.AnalyticsRequest)request, (String)groupingName).expressions.put(expressionName, expression);
    }
}

