/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.stream;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import org.apache.solr.analytics.AnalyticsRequestManager;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;

public class AnalyticsShardResponseParser
extends ResponseParser {
    public static final String BINARY_CONTENT_TYPE = "application/octet-stream";
    public static final String STREAM = "application/octet-stream";
    private final AnalyticsRequestManager manager;

    public AnalyticsShardResponseParser(AnalyticsRequestManager manager) {
        this.manager = manager;
    }

    public String getWriterType() {
        return "analytics_shard_stream";
    }

    public NamedList<Object> processResponse(InputStream body, String encoding) {
        DataInputStream input = new DataInputStream(body);
        NamedList exception = new NamedList();
        try {
            if (input.readBoolean()) {
                this.manager.importShardData(input);
            } else {
                exception.add("Exception", new ObjectInputStream(input).readObject());
            }
        }
        catch (IOException e) {
            exception.add("Exception", (Object)new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't process analytics shard response", (Throwable)e));
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        return exception;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public String getVersion() {
        return "1";
    }

    public NamedList<Object> processResponse(Reader reader) {
        throw new RuntimeException("Cannot handle character stream");
    }
}

