/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.Directory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.backup.repository.LocalFileSystemRepository;
import org.apache.solr.core.snapshots.SolrSnapshotMetaDataManager;
import org.apache.solr.handler.OldBackupDirectory;
import org.apache.solr.handler.ReplicationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapShooter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SolrCore solrCore;
    private String snapshotName = null;
    private String directoryName = null;
    private URI baseSnapDirPath = null;
    private URI snapshotDirPath = null;
    private BackupRepository backupRepo = null;
    private String commitName;
    public static final String DATE_FMT = "yyyyMMddHHmmssSSS";

    @Deprecated
    public SnapShooter(SolrCore core, String location, String snapshotName) {
        String snapDirStr = null;
        snapDirStr = location == null ? core.getDataDir() : core.getCoreDescriptor().getInstanceDir().resolve(location).normalize().toString();
        this.initialize(new LocalFileSystemRepository(), core, Paths.get(snapDirStr, new String[0]).toUri(), snapshotName, null);
    }

    public SnapShooter(BackupRepository backupRepo, SolrCore core, URI location, String snapshotName, String commitName) {
        this.initialize(backupRepo, core, location, snapshotName, commitName);
    }

    private void initialize(BackupRepository backupRepo, SolrCore core, URI location, String snapshotName, String commitName) {
        this.solrCore = Objects.requireNonNull(core);
        this.backupRepo = Objects.requireNonNull(backupRepo);
        this.baseSnapDirPath = location;
        this.snapshotName = snapshotName;
        if (snapshotName != null) {
            this.directoryName = "snapshot." + snapshotName;
        } else {
            SimpleDateFormat fmt = new SimpleDateFormat(DATE_FMT, Locale.ROOT);
            this.directoryName = "snapshot." + fmt.format(new Date());
        }
        this.snapshotDirPath = backupRepo.resolve(location, this.directoryName);
        this.commitName = commitName;
    }

    public BackupRepository getBackupRepository() {
        return this.backupRepo;
    }

    public URI getLocation() {
        return this.baseSnapDirPath;
    }

    public void validateDeleteSnapshot() {
        Objects.requireNonNull(this.snapshotName);
        boolean dirFound = false;
        try {
            String[] paths;
            for (String path : paths = this.backupRepo.listAll(this.baseSnapDirPath)) {
                if (!path.equals(this.directoryName) || this.backupRepo.getPathType(this.baseSnapDirPath.resolve(path)) != BackupRepository.PathType.DIRECTORY) continue;
                dirFound = true;
                break;
            }
            if (!dirFound) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot " + this.snapshotName + " cannot be found in directory: " + this.baseSnapDirPath);
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to find snapshot " + this.snapshotName + " in directory: " + this.baseSnapDirPath, (Throwable)e);
        }
    }

    protected void deleteSnapAsync(ReplicationHandler replicationHandler) {
        new Thread(() -> this.deleteNamedSnapshot(replicationHandler)).start();
    }

    public void validateCreateSnapshot() throws IOException {
        if (!this.backupRepo.exists(this.baseSnapDirPath)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, " Directory does not exist: " + this.snapshotDirPath);
        }
        if (this.backupRepo.exists(this.snapshotDirPath)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot directory already exists: " + this.snapshotDirPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedList createSnapshot() throws Exception {
        if (this.commitName != null) {
            IndexCommit indexCommit = this.getIndexCommitFromName();
            return this.createSnapshot(indexCommit);
        }
        IndexCommit indexCommit = this.getIndexCommit();
        IndexDeletionPolicyWrapper deletionPolicy = this.solrCore.getDeletionPolicy();
        deletionPolicy.saveCommitPoint(indexCommit.getGeneration());
        try {
            NamedList namedList = this.createSnapshot(indexCommit);
            return namedList;
        }
        finally {
            deletionPolicy.releaseCommitPoint(indexCommit.getGeneration());
        }
    }

    private IndexCommit getIndexCommit() throws IOException {
        IndexDeletionPolicyWrapper delPolicy = this.solrCore.getDeletionPolicy();
        IndexCommit indexCommit = delPolicy.getLatestCommit();
        if (indexCommit != null) {
            return indexCommit;
        }
        return this.solrCore.withSearcher(searcher -> searcher.getIndexReader().getIndexCommit());
    }

    private IndexCommit getIndexCommitFromName() throws IOException {
        assert (this.commitName != null);
        SolrSnapshotMetaDataManager snapshotMgr = this.solrCore.getSnapshotMetaDataManager();
        Optional<IndexCommit> commit = snapshotMgr.getIndexCommitByName(this.commitName);
        if (!commit.isPresent()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to find an index commit with name " + this.commitName + " for core " + this.solrCore.getName());
        }
        IndexCommit indexCommit = commit.get();
        return indexCommit;
    }

    public void createSnapAsync(int numberToKeep, Consumer<NamedList> result) throws IOException {
        IndexCommit indexCommit = this.commitName != null ? this.getIndexCommitFromName() : this.getIndexCommit();
        this.createSnapAsync(indexCommit, numberToKeep, result);
    }

    private void createSnapAsync(IndexCommit indexCommit, int numberToKeep, Consumer<NamedList> result) {
        new Thread(() -> {
            try {
                result.accept(this.createSnapshot(indexCommit));
            }
            catch (Exception e) {
                log.error("Exception while creating snapshot", (Throwable)e);
                NamedList snapShootDetails = new NamedList();
                snapShootDetails.add("exception", (Object)e.getMessage());
                result.accept(snapShootDetails);
            }
            finally {
                this.solrCore.getDeletionPolicy().releaseCommitPoint(indexCommit.getGeneration());
            }
            if (this.snapshotName == null) {
                try {
                    this.deleteOldBackups(numberToKeep);
                }
                catch (IOException e) {
                    log.warn("Unable to delete old snapshots ", (Throwable)e);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedList createSnapshot(IndexCommit indexCommit) throws Exception {
        assert (indexCommit != null);
        log.info("Creating backup snapshot " + (this.snapshotName == null ? "<not named>" : this.snapshotName) + " at " + this.baseSnapDirPath);
        boolean success = false;
        try {
            NamedList details = new NamedList();
            details.add("startTime", (Object)new Date().toString());
            Collection files = indexCommit.getFileNames();
            Directory dir = this.solrCore.getDirectoryFactory().get(this.solrCore.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, this.solrCore.getSolrConfig().indexConfig.lockType);
            try {
                for (String fileName : files) {
                    this.backupRepo.copyFileFrom(dir, fileName, this.snapshotDirPath);
                }
            }
            finally {
                this.solrCore.getDirectoryFactory().release(dir);
            }
            details.add("fileCount", (Object)files.size());
            details.add("status", (Object)"success");
            details.add("snapshotCompletedAt", (Object)new Date().toString());
            details.add("snapshotName", (Object)this.snapshotName);
            log.info("Done creating backup snapshot: " + (this.snapshotName == null ? "<not named>" : this.snapshotName) + " at " + this.baseSnapDirPath);
            success = true;
            NamedList namedList = details;
            return namedList;
        }
        finally {
            if (!success) {
                try {
                    this.backupRepo.deleteDirectory(this.snapshotDirPath);
                }
                catch (Exception excDuringDelete) {
                    log.warn("Failed to delete " + this.snapshotDirPath + " after snapshot creation failed due to: " + excDuringDelete);
                }
            }
        }
    }

    private void deleteOldBackups(int numberToKeep) throws IOException {
        String[] paths = this.backupRepo.listAll(this.baseSnapDirPath);
        ArrayList<OldBackupDirectory> dirs = new ArrayList<OldBackupDirectory>();
        for (String f : paths) {
            OldBackupDirectory obd;
            if (this.backupRepo.getPathType(this.baseSnapDirPath.resolve(f)) != BackupRepository.PathType.DIRECTORY || !(obd = new OldBackupDirectory(this.baseSnapDirPath, f)).getTimestamp().isPresent()) continue;
            dirs.add(obd);
        }
        if (numberToKeep > dirs.size() - 1) {
            return;
        }
        Collections.sort(dirs);
        int i = 1;
        for (OldBackupDirectory dir : dirs) {
            if (i++ <= numberToKeep) continue;
            this.backupRepo.deleteDirectory(dir.getPath());
        }
    }

    protected void deleteNamedSnapshot(ReplicationHandler replicationHandler) {
        log.info("Deleting snapshot: " + this.snapshotName);
        NamedList details = new NamedList();
        try {
            URI path = this.baseSnapDirPath.resolve("snapshot." + this.snapshotName);
            this.backupRepo.deleteDirectory(path);
            details.add("status", (Object)"success");
            details.add("snapshotDeletedAt", (Object)new Date().toString());
        }
        catch (IOException e) {
            details.add("status", (Object)("Unable to delete snapshot: " + this.snapshotName));
            log.warn("Unable to delete snapshot: " + this.snapshotName, (Throwable)e);
        }
        replicationHandler.snapShootDetails = details;
    }
}

