/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.cloud.api.collections.AliasCmd;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.api.collections.TimeRoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.DateMathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintainTimeRoutedAliasCmd
extends AliasCmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String IF_MOST_RECENT_COLL_NAME = "ifMostRecentCollName";
    private final OverseerCollectionMessageHandler ocmh;

    public MaintainTimeRoutedAliasCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    public static NamedList remoteInvoke(CollectionsHandler collHandler, String aliasName, String mostRecentCollName) throws Exception {
        String operation = CollectionParams.CollectionAction.MAINTAINTIMEROUTEDALIAS.toLower();
        HashMap<String, String> msg = new HashMap<String, String>();
        msg.put("operation", operation);
        msg.put("name", aliasName);
        msg.put(IF_MOST_RECENT_COLL_NAME, mostRecentCollName);
        SolrResponse rsp = collHandler.sendToOCPQueue(new ZkNodeProps(msg));
        if (rsp.getException() != null) {
            throw rsp.getException();
        }
        return rsp.getResponse();
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        NamedList createResults;
        String aliasName = message.getStr("name");
        String ifMostRecentCollName = message.getStr(IF_MOST_RECENT_COLL_NAME);
        ZkStateReader.AliasesManager aliasesManager = this.ocmh.zkStateReader.aliasesManager;
        Aliases aliases = aliasesManager.getAliases();
        Map aliasMetadata = aliases.getCollectionAliasProperties(aliasName);
        if (aliasMetadata.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Alias " + aliasName + " does not exist or is not a routed alias.");
        }
        TimeRoutedAlias timeRoutedAlias = new TimeRoutedAlias(aliasName, aliasMetadata);
        List<Map.Entry<Instant, String>> parsedCollections = timeRoutedAlias.parseCollections(aliases);
        Map.Entry<Instant, String> mostRecentEntry = parsedCollections.get(0);
        Instant mostRecentCollTimestamp = mostRecentEntry.getKey();
        String mostRecentCollName = mostRecentEntry.getValue();
        if (ifMostRecentCollName != null) {
            if (!mostRecentCollName.equals(ifMostRecentCollName)) {
                String msg = "ifMostRecentCollName expected " + ifMostRecentCollName + " but it's " + mostRecentCollName;
                if (parsedCollections.stream().map(Map.Entry::getValue).noneMatch(ifMostRecentCollName::equals)) {
                    msg = msg + ". Furthermore this collection isn't in the list of collections referenced by the alias.";
                }
                log.info(msg);
                results.add("message", (Object)msg);
                return;
            }
        } else if (mostRecentCollTimestamp.isAfter(Instant.now())) {
            String msg = "Most recent collection is in the future, so we won't create another.";
            log.info("Most recent collection is in the future, so we won't create another.");
            results.add("message", (Object)"Most recent collection is in the future, so we won't create another.");
            return;
        }
        Instant nextCollTimestamp = timeRoutedAlias.computeNextCollTimestamp(mostRecentCollTimestamp);
        String createCollName = TimeRoutedAlias.formatCollectionNameFromInstant(aliasName, nextCollTimestamp);
        NamedList deleteResults = this.deleteOldestCollectionsAndUpdateAlias(timeRoutedAlias, aliasesManager, nextCollTimestamp);
        if (deleteResults != null) {
            results.add("delete", (Object)deleteResults);
        }
        if ((createResults = MaintainTimeRoutedAliasCmd.createCollectionAndWait(clusterState, aliasName, aliasMetadata, createCollName, this.ocmh)) != null) {
            results.add("create", (Object)createResults);
        }
        this.updateAlias(aliasName, aliasesManager, createCollName);
    }

    NamedList deleteOldestCollectionsAndUpdateAlias(TimeRoutedAlias timeRoutedAlias, ZkStateReader.AliasesManager aliasesManager, Instant now) throws Exception {
        Instant delBefore;
        String autoDeleteAgeMathStr = timeRoutedAlias.getAutoDeleteAgeMath();
        if (autoDeleteAgeMathStr == null) {
            return null;
        }
        try {
            delBefore = new DateMathParser(Date.from(now), timeRoutedAlias.getTimeZone()).parseMath(autoDeleteAgeMathStr).toInstant();
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        String aliasName = timeRoutedAlias.getAliasName();
        LinkedHashSet collectionsToDelete = new LinkedHashSet();
        aliasesManager.applyModificationAndExportToZk(curAliases -> {
            List<Map.Entry<Instant, String>> parsedCollections = timeRoutedAlias.parseCollections((Aliases)curAliases);
            int numToKeep = 0;
            DateTimeFormatter dtf = null;
            if (log.isDebugEnabled()) {
                dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.n", Locale.ROOT);
                dtf = dtf.withZone(ZoneId.of("UTC"));
            }
            for (Map.Entry<Instant, String> parsedCollection : parsedCollections) {
                ++numToKeep;
                Instant colInstant = parsedCollection.getKey();
                if (colInstant.isBefore(delBefore) || colInstant.equals(delBefore)) {
                    if (!log.isDebugEnabled()) break;
                    log.debug("{} is equal to or before {} deletions may be required", (Object)dtf.format(colInstant), (Object)dtf.format(delBefore));
                    break;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("{} is not before {} and will be retained", (Object)dtf.format(colInstant), (Object)dtf.format(delBefore));
            }
            if (numToKeep == parsedCollections.size()) {
                log.debug("No old time routed collections to delete... parsed collections={}", parsedCollections);
                return curAliases;
            }
            log.debug("Collections will be deleted... parsed collections={}", parsedCollections);
            Map collectionAliasListMap = curAliases.getCollectionAliasListMap();
            List targetList = (List)collectionAliasListMap.get(aliasName);
            log.debug("Iterating backwards on collection list to find deletions: {}", (Object)targetList);
            for (int i = targetList.size() - 1; i >= numToKeep; --i) {
                String toDelete = (String)targetList.get(i);
                log.debug("Adding to TRA delete list:{}", (Object)toDelete);
                collectionsToDelete.add(toDelete);
            }
            List collectionsToKeep = targetList.subList(0, numToKeep);
            String collectionsToKeepStr = StrUtils.join(collectionsToKeep, (char)',');
            return curAliases.cloneWithCollectionAlias(aliasName, collectionsToKeepStr);
        });
        if (collectionsToDelete.isEmpty()) {
            return null;
        }
        log.info("Removing old time routed collections: {}", collectionsToDelete);
        CollectionsHandler collHandler = this.ocmh.overseer.getCoreContainer().getCollectionsHandler();
        NamedList results = new NamedList();
        for (String collection : collectionsToDelete) {
            SolrParams reqParams = CollectionAdminRequest.deleteCollection((String)collection).getParams();
            SolrQueryResponse rsp = new SolrQueryResponse();
            collHandler.handleRequestBody(new LocalSolrQueryRequest(null, reqParams), rsp);
            results.add(collection, (Object)rsp.getValues());
        }
        return results;
    }
}

