/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.Resource_ImplBase;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;

public class ResourceCreationSpecifier_impl
extends MetaDataObject_impl
implements ResourceCreationSpecifier {
    private String mImplementationName;
    private String mFrameworkImplementation;
    private ResourceMetaData mMetaData;
    private List<ExternalResourceDependency> mExternalResourceDependencies = new ArrayList<ExternalResourceDependency>();
    private ResourceManagerConfiguration mResourceManagerConfiguration;
    static final long serialVersionUID = 7946890459654653436L;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("resourceCreationSpecifier", new PropertyXmlInfo[]{new PropertyXmlInfo("frameworkImplementation"), new PropertyXmlInfo("implementationName"), new PropertyXmlInfo("metaData", null), new PropertyXmlInfo("externalResourceDependencies"), new PropertyXmlInfo("externalResources"), new PropertyXmlInfo("resourceManagerConfiguration", null)});

    public String getFrameworkImplementation() {
        return this.mFrameworkImplementation;
    }

    public void setFrameworkImplementation(String aFrameworkImplementation) {
        this.mFrameworkImplementation = aFrameworkImplementation;
    }

    public String getImplementationName() {
        return this.mImplementationName;
    }

    public void setImplementationName(String aImplementationName) {
        this.mImplementationName = aImplementationName;
    }

    public ResourceMetaData getMetaData() {
        return this.mMetaData;
    }

    public void setMetaData(ResourceMetaData aMetaData) {
        this.mMetaData = aMetaData;
    }

    public ExternalResourceDependency[] getExternalResourceDependencies() {
        ExternalResourceDependency[] result = new ExternalResourceDependency[this.mExternalResourceDependencies.size()];
        this.mExternalResourceDependencies.toArray(result);
        return result;
    }

    public void setExternalResourceDependencies(ExternalResourceDependency[] aDependencies) {
        this.mExternalResourceDependencies = new ArrayList<ExternalResourceDependency>();
        if (aDependencies != null) {
            for (int i = 0; i < aDependencies.length; ++i) {
                this.mExternalResourceDependencies.add(aDependencies[i]);
            }
        }
    }

    public ExternalResourceDependency getExternalResourceDependency(String aKey) {
        for (ExternalResourceDependency dep : this.mExternalResourceDependencies) {
            if (!aKey.equals(dep.getKey())) continue;
            return dep;
        }
        return null;
    }

    public ResourceManagerConfiguration getResourceManagerConfiguration() {
        return this.mResourceManagerConfiguration;
    }

    public void setResourceManagerConfiguration(ResourceManagerConfiguration aResourceManagerConfiguration) {
        this.mResourceManagerConfiguration = aResourceManagerConfiguration;
    }

    public void doFullValidation() throws ResourceInitializationException {
        this.doFullValidation(UIMAFramework.newDefaultResourceManager());
    }

    public void doFullValidation(ResourceManager aResourceManager) throws ResourceInitializationException {
        DummyResource dummy = new DummyResource();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("RESOURCE_MANAGER", aResourceManager);
        dummy.initialize(this, params);
    }

    public final void validate() throws ResourceInitializationException, ResourceConfigurationException {
        this.validate(UIMAFramework.newDefaultResourceManager());
    }

    public void validate(ResourceManager aResourceManager) throws ResourceInitializationException, ResourceConfigurationException {
        this.validateConfigurationParameters(aResourceManager);
    }

    protected void validateConfigurationParameters(ResourceManager aResourceManager) throws ResourceInitializationException {
        ConfigurationParameterDeclarations cfgParamDecls = this.getMetaData().getConfigurationParameterDeclarations();
        ConfigurationParameter[] params = cfgParamDecls.getConfigurationParameters();
        if (params.length > 0) {
            this.checkForDuplicateParameterNames(params);
            this.checkForInvalidParameterOverrides(params, null, aResourceManager);
        } else {
            ConfigurationGroup[] groups;
            ConfigurationParameter[] commonParams = cfgParamDecls.getCommonParameters();
            HashSet<String> commonParamNames = new HashSet<String>();
            if (commonParams != null) {
                for (int i = 0; i < commonParams.length; ++i) {
                    if (commonParamNames.add(commonParams[i].getName())) continue;
                    throw new ResourceInitializationException("duplicate_configuration_parameter_name", new Object[]{commonParams[i].getName(), this.getMetaData().getName(), commonParams[i].getSourceUrlString()});
                }
            }
            if ((groups = cfgParamDecls.getConfigurationGroups()) != null) {
                HashMap groupToParamSetMap = new HashMap();
                for (int i = 0; i < groups.length; ++i) {
                    String[] names = groups[i].getNames();
                    for (int j = 0; j < names.length; ++j) {
                        ConfigurationParameter[] paramsInGroup;
                        HashSet<String> paramNamesInGroup = (HashSet<String>)groupToParamSetMap.get(names[j]);
                        if (paramNamesInGroup == null) {
                            paramNamesInGroup = new HashSet<String>(commonParamNames);
                        }
                        if ((paramsInGroup = groups[i].getConfigurationParameters()) != null) {
                            for (int k = 0; k < paramsInGroup.length; ++k) {
                                if (paramNamesInGroup.add(paramsInGroup[k].getName())) continue;
                                throw new ResourceInitializationException("duplicate_configuration_parameter_name", new Object[]{paramsInGroup[k].getName(), this.getMetaData().getName(), paramsInGroup[k].getSourceUrlString()});
                            }
                        }
                        this.checkForInvalidParameterOverrides(paramsInGroup, names[j], aResourceManager);
                        if (commonParams == null) continue;
                        this.checkForInvalidParameterOverrides(commonParams, names[j], aResourceManager);
                    }
                }
            }
        }
    }

    protected void checkForDuplicateParameterNames(ConfigurationParameter[] aParams) throws ResourceInitializationException {
        HashSet<String> paramNames = new HashSet<String>();
        for (int i = 0; i < aParams.length; ++i) {
            if (paramNames.add(aParams[i].getName())) continue;
            throw new ResourceInitializationException("duplicate_configuration_parameter_name", new Object[]{aParams[i].getName(), this.getMetaData().getName(), aParams[i].getSourceUrlString()});
        }
    }

    protected void checkForInvalidParameterOverrides(ConfigurationParameter[] aParams, String aGroupName, ResourceManager aResourceManager) throws ResourceInitializationException {
        for (int i = 0; i < aParams.length; ++i) {
            String[] overrides = aParams[i].getOverrides();
            if (overrides.length <= 0) continue;
            throw new ResourceInitializationException("param_override_in_primitive", new Object[]{aParams[i].getName(), this.getMetaData().getName(), aParams[i].getSourceUrlString()});
        }
    }

    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }

    private static class DummyResource
    extends Resource_ImplBase {
        private DummyResource() {
        }
    }
}

