/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.TIFFFaxDecoder;

public class CCITTFaxDecodeFilter
implements Filter {
    private static final Log log = LogFactory.getLog(CCITTFaxDecodeFilter.class);

    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        COSBase decodeP = options.getDictionaryObject(COSName.DECODE_PARMS);
        COSDictionary decodeParms = null;
        if (decodeP instanceof COSDictionary) {
            decodeParms = (COSDictionary)decodeP;
        } else if (decodeP instanceof COSArray) {
            decodeParms = (COSDictionary)((COSArray)decodeP).get(0);
        }
        int length = options.getInt(COSName.LENGTH);
        byte[] compressed = new byte[length];
        compressedData.read(compressed, 0, length);
        int cols = decodeParms.getInt(COSName.COLUMNS, 1728);
        int rows = decodeParms.getInt(COSName.ROWS, 0);
        int height = options.getInt(COSName.HEIGHT, 0);
        rows = rows > 0 && height > 0 ? Math.min(rows, height) : Math.max(rows, height);
        int k = decodeParms.getInt(COSName.K);
        int arraySize = (cols + 7) / 8 * rows;
        byte[] decompressed = new byte[arraySize];
        TIFFFaxDecoder faxDecoder = new TIFFFaxDecoder(1, cols, rows);
        long tiffOptions = 0L;
        if (k == 0) {
            faxDecoder.decode1D(decompressed, compressed, 0, rows);
        } else if (k > 0) {
            faxDecoder.decode2D(decompressed, compressed, 0, rows, tiffOptions);
        } else if (k < 0) {
            faxDecoder.decodeT6(decompressed, compressed, 0, rows, tiffOptions);
        }
        result.write(decompressed);
    }

    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        log.warn((Object)"CCITTFaxDecode.encode is not implemented yet, skipping this stream.");
    }
}

