/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.httpclient;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.httpclient.HttpClientFactory;
import org.carrot2.util.httpclient.HttpHeaders;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtils {
    private static final String COMPRESSION_GZIP = "gzip";
    private static final String COMPRESSION_NONE = "uncompressed";

    private HttpUtils() {
    }

    public static Response doGET(String url, Collection<NameValuePair> params, Collection<Header> headers) throws IOException {
        return HttpUtils.doGET(url, params, headers, null, null);
    }

    public static Response doGET(String url, Collection<NameValuePair> params, Collection<Header> headers, String user, String password) throws IOException {
        return HttpUtils.doGET(url, params, headers, user, password, HttpClientFactory.DEFAULT_TIMEOUT);
    }

    public static Response doGET(String url, Collection<NameValuePair> params, Collection<Header> headers, String user, String password, int timeout) throws IOException {
        DefaultHttpClient client = HttpClientFactory.getTimeoutingClient(timeout);
        client.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        HttpGet request = new HttpGet();
        if (user != null && password != null) {
            client.getCredentialsProvider().setCredentials(new AuthScope(null, 80, null), (Credentials)new UsernamePasswordCredentials(user, password));
        }
        Response response = new Response();
        try {
            params = params == null ? Lists.newArrayList() : Lists.newArrayList((Iterable)params);
            URI uri = new URI(url);
            params.addAll(URLEncodedUtils.parse((URI)uri, (String)"UTF-8"));
            uri = URIUtils.createURI((String)uri.getScheme(), (String)uri.getHost(), (int)uri.getPort(), (String)uri.getPath(), (String)URLEncodedUtils.format((List)Lists.newArrayList((Iterable)params), (String)"UTF-8"), null);
            request.setURI(uri);
            request.setHeader(HttpHeaders.URL_ENCODED);
            request.setHeader(HttpHeaders.GZIP_ENCODING);
            if (headers != null) {
                for (Header header : headers) {
                    request.setHeader(header);
                }
            }
            LoggerFactory.getLogger(HttpUtils.class).debug("GET: " + request.getURI());
            HttpResponse httpResponse = client.execute((HttpUriRequest)request);
            response.status = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            InputStream stream = entity.getContent();
            Header encoded = entity.getContentEncoding();
            if (encoded != null && COMPRESSION_GZIP.equalsIgnoreCase(encoded.getValue())) {
                stream = new GZIPInputStream(stream);
                response.compression = COMPRESSION_GZIP;
            } else {
                response.compression = COMPRESSION_NONE;
            }
            Header[] respHeaders = httpResponse.getAllHeaders();
            response.headers = new String[respHeaders.length][];
            for (int i = 0; i < respHeaders.length; ++i) {
                response.headers[i] = new String[]{respHeaders[i].getName(), respHeaders[i].getValue()};
            }
            response.payload = StreamUtils.readFullyAndClose(stream);
            Response response2 = response;
            return response2;
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    public static final class Response {
        public byte[] payload;
        public int status;
        public String compression;
        public String[][] headers;

        public InputStream getPayloadAsStream() {
            return new ByteArrayInputStream(this.payload);
        }
    }
}

