/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.carrot2.util.Pair;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BindableUtils {
    private static final HashMap<Pair<Class<? extends Annotation>, Class<?>>, Collection<Field>> FIELD_CACHE = Maps.newHashMap();

    static Collection<Field> getFieldsFromBindableHierarchy(Class<?> clazz) {
        return BindableUtils.getFieldsFromHierarchy(clazz, Bindable.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<Field> getFieldsFromHierarchy(Class<?> clazz, Class<? extends Annotation> marker) {
        HashMap<Pair<Class<? extends Annotation>, Class<?>>, Collection<Field>> hashMap = FIELD_CACHE;
        synchronized (hashMap) {
            Pair key = new Pair(marker, clazz);
            Collection<Field> fields = FIELD_CACHE.get(key);
            if (fields == null) {
                Class<?> superClass;
                fields = new LinkedHashSet<Field>();
                if (clazz.getAnnotation(marker) != null) {
                    fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
                }
                if ((superClass = clazz.getSuperclass()) != null) {
                    fields.addAll(BindableUtils.getFieldsFromHierarchy(superClass, marker));
                }
                FIELD_CACHE.put(key, fields);
            }
            return fields;
        }
    }

    public static String getKey(Field field) {
        Attribute attributeAnnotation = field.getAnnotation(Attribute.class);
        if (attributeAnnotation == null) {
            return null;
        }
        if ("".equals(attributeAnnotation.key())) {
            return BindableUtils.getPrefix(field.getDeclaringClass()) + "." + field.getName();
        }
        return attributeAnnotation.key();
    }

    static String getPrefix(Class<?> bindableClass) {
        Bindable bindable = bindableClass.getAnnotation(Bindable.class);
        if (bindable == null) {
            throw new IllegalArgumentException("The argument must have @" + Bindable.class.getSimpleName() + " annotation");
        }
        if ("".equals(bindable.prefix())) {
            return bindableClass.getName();
        }
        return bindable.prefix();
    }
}

