/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;

@Bindable(prefix="GenitiveLabelFilter")
public class GenitiveLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    public boolean enabled = true;
    private static final char[][] ENDINGS = new char[][]{"'s".toCharArray(), "`s".toCharArray(), "s'".toCharArray(), "s`".toCharArray()};

    public boolean acceptPhrase(PreprocessingContext context, int phraseIndex) {
        int[] wordIndices = context.allPhrases.wordIndices[phraseIndex];
        return this.isGenitive(context.allWords.image, wordIndices[wordIndices.length - 1]);
    }

    public boolean acceptWord(PreprocessingContext context, int wordIndex) {
        return this.isGenitive(context.allWords.image, wordIndex);
    }

    private boolean isGenitive(char[][] wordImage, int wordIndex) {
        char[] image = wordImage[wordIndex];
        block0: for (char[] ending : ENDINGS) {
            if (image.length < ending.length) continue;
            for (int i = 0; i < ending.length; ++i) {
                if (image[image.length - ending.length + i] != ending[i]) continue block0;
            }
            return false;
        }
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

