/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.boss;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.boss.ImageResult;
import org.carrot2.source.boss.ImagesResultSet;
import org.carrot2.source.boss.NewsResult;
import org.carrot2.source.boss.NewsResultSet;
import org.carrot2.source.boss.WebResult;
import org.carrot2.source.boss.WebResultSet;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.slf4j.LoggerFactory;

@Root(name="ysearchresponse", strict=false)
final class YSearchResponse {
    @Attribute(name="responsecode", required=false)
    public Integer responseCode;
    @Element(name="nextpage", required=false)
    public String nextPageURI;
    @Element(name="resultset_web", required=false)
    public WebResultSet webResultSet;
    @Element(name="resultset_news", required=false)
    public NewsResultSet newsResultSet;
    @Element(name="resultset_images", required=false)
    public ImagesResultSet imagesResultSet;
    @Element(name="language", required=false)
    public String language;

    YSearchResponse() {
    }

    public void populate(SearchEngineResponse response, LanguageCode requestedLanguage) {
        Document document;
        if (this.webResultSet != null) {
            response.metadata.put("resultsTotal", this.webResultSet.deephits);
            if (this.webResultSet.results != null) {
                for (WebResult webResult : this.webResultSet.results) {
                    document = new Document(webResult.title, webResult.summary, webResult.url);
                    document.setField("click-url", webResult.clickURL);
                    try {
                        document.setField("size", Long.parseLong(webResult.size));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    response.results.add(document);
                }
            }
        } else if (this.newsResultSet != null) {
            response.metadata.put("resultsTotal", this.newsResultSet.deephits);
            if (this.newsResultSet.results != null) {
                HashSet unknownLanguages = Sets.newHashSet();
                for (NewsResult result : this.newsResultSet.results) {
                    Document document2 = new Document(result.title, result.summary, result.url);
                    document2.setField("click-url", result.clickURL);
                    if (StringUtils.isNotBlank((String)result.source)) {
                        document2.setField("sources", Lists.newArrayList((Object[])new String[]{result.source}));
                    }
                    if (StringUtils.isNotBlank((String)result.language)) {
                        try {
                            document2.setLanguage(LanguageCode.valueOf(result.language));
                        }
                        catch (IllegalArgumentException ignored) {
                            unknownLanguages.add(result.language);
                        }
                    }
                    response.results.add(document2);
                }
                if (!unknownLanguages.isEmpty()) {
                    LoggerFactory.getLogger((String)this.getClass().getName()).warn("Unknown language: " + ((Object)unknownLanguages).toString());
                }
            }
        } else if (this.imagesResultSet != null) {
            response.metadata.put("resultsTotal", this.imagesResultSet.deephits);
            if (this.imagesResultSet.results != null) {
                for (ImageResult imageResult : this.imagesResultSet.results) {
                    document = new Document(imageResult.title, imageResult.summary, imageResult.refererURL);
                    document.setField("click-url", imageResult.refererClickURL);
                    document.setField("thumbnail-url", imageResult.thumbnailURL);
                    response.results.add(document);
                }
            }
        }
        if (requestedLanguage != null) {
            for (Document document2 : response.results) {
                if (document2.getLanguage() != null) continue;
                document2.setLanguage(requestedLanguage);
            }
        }
    }
}

