/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization.seeding;

import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.matrix.factorization.KMeansMatrixFactorization;
import org.carrot2.matrix.factorization.seeding.ISeedingStrategy;

public class KMeansSeedingStrategy
implements ISeedingStrategy {
    private int maxIterations;
    private static final int DEFAULT_MAX_ITERATIONS = 5;

    public KMeansSeedingStrategy() {
        this(5);
    }

    public KMeansSeedingStrategy(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void seed(DoubleMatrix2D A, DoubleMatrix2D U, DoubleMatrix2D V) {
        int c;
        int r;
        KMeansMatrixFactorization kMeansMatrixFactorization = new KMeansMatrixFactorization(A);
        kMeansMatrixFactorization.setK(U.columns());
        kMeansMatrixFactorization.setMaxIterations(this.maxIterations);
        kMeansMatrixFactorization.compute();
        U.assign(kMeansMatrixFactorization.getU());
        for (r = 0; r < U.rows(); ++r) {
            for (c = 0; c < U.columns(); ++c) {
                if (!(U.getQuick(r, c) < 0.001)) continue;
                U.setQuick(r, c, 0.05);
            }
        }
        V.assign(kMeansMatrixFactorization.getV());
        for (r = 0; r < V.rows(); ++r) {
            for (c = 0; c < V.columns(); ++c) {
                if (V.getQuick(r, c) != 0.0) continue;
                V.setQuick(r, c, 0.05);
            }
        }
    }

    public String toString() {
        return "KM";
    }
}

