/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix;

import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.matrix.NNIInterface;

public class NNIDenseDoubleMatrix2D
extends DenseDoubleMatrix2D {
    private static final long serialVersionUID = 1L;

    public NNIDenseDoubleMatrix2D(double[][] values) {
        super(values);
    }

    public NNIDenseDoubleMatrix2D(int rows, int columns) {
        super(rows, columns);
    }

    public NNIDenseDoubleMatrix2D(int rows, int columns, double[] elements, int rowZero, int columnZero, int rowStride, int columnStride) {
        super(rows, columns, elements, rowZero, columnZero, rowStride, columnStride);
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, boolean transposeA) {
        return super.zMult(y, z, alpha, beta, transposeA);
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        int columnsA;
        if (B.getClass().getName().endsWith("SelectedDenseDoubleMatrix2D")) {
            return B.zMult((DoubleMatrix2D)this, C, alpha, beta, !transposeB, !transposeA).viewDice();
        }
        int rowsB = transposeB ? B.columns() : B.rows();
        int columnsB = transposeB ? B.rows() : B.columns();
        int rowsA = transposeA ? this.columns() : this.rows();
        int n = columnsA = transposeA ? this.rows() : this.columns();
        if (C == null) {
            C = new NNIDenseDoubleMatrix2D(rowsA, columnsB);
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int rowsC = C.rows();
        int columnsC = C.columns();
        if (rowsB != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (rowsC != rowsA || columnsC != columnsB) {
            throw new IllegalArgumentException("Incompatibile result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (!NNIInterface.isNativeBlasAvailable() || !(B instanceof NNIDenseDoubleMatrix2D) || !(C instanceof NNIDenseDoubleMatrix2D) || this.isView() || ((NNIDenseDoubleMatrix2D)B).isView() || ((NNIDenseDoubleMatrix2D)((Object)C)).isView()) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        NNIInterface.getBlas().gemm(this, (NNIDenseDoubleMatrix2D)B, (NNIDenseDoubleMatrix2D)((Object)C), transposeA, transposeB, columnsA, alpha, this.columns, beta);
        return C;
    }

    public boolean isView() {
        return super.isView();
    }

    public double[] getData() {
        return this.elements;
    }

    public void transpose() {
        int tmp = this.rows;
        this.rows = this.columns;
        this.columns = tmp;
        tmp = this.rowStride;
        this.rowStride = this.columnStride;
        this.columnStride = tmp;
        tmp = this.rowZero;
        this.rowZero = this.columnZero;
        this.columnZero = tmp;
    }

    public boolean equals(Object matrix) {
        return this == matrix;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }
}

