/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix;

import java.util.Arrays;
import org.apache.mahout.math.function.DoubleComparator;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.util.DoubleComparators;

public class MatrixUtils {
    public static DoubleMatrix2D normalizeColumnL2(DoubleMatrix2D A, double[] work) {
        work = MatrixUtils.prepareWork(A, work);
        for (int r = 0; r < A.rows(); ++r) {
            for (int c = 0; c < A.columns(); ++c) {
                int n = c;
                work[n] = work[n] + A.getQuick(r, c) * A.getQuick(r, c);
            }
        }
        for (int c = 0; c < A.columns(); ++c) {
            work[c] = Math.sqrt(work[c]);
        }
        MatrixUtils.normalizeColumns(A, work);
        return A;
    }

    public static DoubleMatrix2D normalizeSparseColumnL2(DoubleMatrix2D A, double[] work) {
        int i;
        IntArrayList rows = new IntArrayList(A.cardinality());
        IntArrayList columns = new IntArrayList(A.cardinality());
        DoubleArrayList values = new DoubleArrayList(A.cardinality());
        A.getNonZeros(rows, columns, values);
        work = MatrixUtils.prepareWork(A, work);
        for (i = 0; i < values.size(); ++i) {
            int n = columns.get(i);
            work[n] = work[n] + values.get(i) * values.get(i);
        }
        for (int c = 0; c < A.columns(); ++c) {
            work[c] = Math.sqrt(work[c]);
        }
        for (i = 0; i < values.size(); ++i) {
            A.setQuick(rows.get(i), columns.get(i), values.get(i) / work[columns.get(i)]);
        }
        return A;
    }

    public static DoubleMatrix2D normalizeColumnL1(DoubleMatrix2D A, double[] work) {
        work = MatrixUtils.prepareWork(A, work);
        for (int r = 0; r < A.rows(); ++r) {
            for (int c = 0; c < A.columns(); ++c) {
                int n = c;
                work[n] = work[n] + A.getQuick(r, c);
            }
        }
        MatrixUtils.normalizeColumns(A, work);
        return A;
    }

    private static double[] prepareWork(DoubleMatrix2D A, double[] work) {
        if (work == null || work.length != A.columns()) {
            work = new double[A.columns()];
        } else {
            Arrays.fill(work, 0.0);
        }
        return work;
    }

    private static void normalizeColumns(DoubleMatrix2D A, double[] work) {
        for (int r = A.rows() - 1; r >= 0; --r) {
            for (int c = 0; c < A.columns(); ++c) {
                if (work[c] == 0.0) continue;
                A.setQuick(r, c, A.getQuick(r, c) / work[c]);
            }
        }
    }

    public static double computeOrthogonality(DoubleMatrix2D A) {
        double orthogonality = 0.0;
        DoubleMatrix2D cosines = A.zMult(A, null, 1.0, 0.0, true, false);
        for (int r = 0; r < cosines.rows(); ++r) {
            for (int c = r + 1; c < cosines.columns(); ++c) {
                orthogonality += cosines.getQuick(r, c);
            }
        }
        return orthogonality / ((double)((cosines.rows() - 1) * cosines.rows()) / 2.0);
    }

    public static double computeSparseness(DoubleMatrix2D A) {
        int count = 0;
        for (int r = 0; r < A.rows(); ++r) {
            for (int c = 0; c < A.columns(); ++c) {
                if (A.getQuick(r, c) == 0.0) continue;
                ++count;
            }
        }
        return (double)count / (double)(A.rows() * A.columns());
    }

    public static int[] minInColumns(DoubleMatrix2D A, int[] indices, double[] minValues) {
        return MatrixUtils.inColumns(A, indices, minValues, DoubleComparators.REVERSED_ORDER, (DoubleFunction)Functions.identity);
    }

    public static int[] maxInColumns(DoubleMatrix2D A, int[] indices, double[] maxValues) {
        return MatrixUtils.maxInColumns(A, indices, maxValues, (DoubleFunction)Functions.identity);
    }

    public static int[] maxInColumns(DoubleMatrix2D A, int[] indices, double[] maxValues, DoubleFunction transform) {
        return MatrixUtils.inColumns(A, indices, maxValues, DoubleComparators.NATURAL_ORDER, transform);
    }

    static int[] inColumns(DoubleMatrix2D A, int[] indices, double[] extValues, DoubleComparator doubleComparator, DoubleFunction transform) {
        if (indices == null) {
            indices = new int[A.columns()];
        }
        if (A.columns() == 0 || A.rows() == 0) {
            return indices;
        }
        if (extValues == null) {
            extValues = new double[A.columns()];
        }
        for (int c = 0; c < A.columns(); ++c) {
            extValues[c] = transform.apply(A.getQuick(0, c));
        }
        Arrays.fill(indices, 0);
        for (int r = 1; r < A.rows(); ++r) {
            for (int c = 0; c < A.columns(); ++c) {
                double transformed = transform.apply(A.getQuick(r, c));
                if (doubleComparator.compare(transformed, extValues[c]) <= 0) continue;
                extValues[c] = transformed;
                indices[c] = r;
            }
        }
        return indices;
    }

    public static int maxInRow(DoubleMatrix2D A, int row) {
        int index = 0;
        double max = A.getQuick(row, index);
        for (int c = 1; c < A.columns(); ++c) {
            if (!(max < A.getQuick(row, c))) continue;
            max = A.getQuick(row, c);
            index = c;
        }
        return index;
    }

    public static double[] sumRows(DoubleMatrix2D A, double[] sums) {
        if (sums == null || A.rows() != sums.length) {
            sums = new double[A.rows()];
        } else {
            Arrays.fill(sums, 0.0);
        }
        for (int r = 0; r < A.rows(); ++r) {
            for (int c = 0; c < A.columns(); ++c) {
                int n = r;
                sums[n] = sums[n] + A.getQuick(r, c);
            }
        }
        return sums;
    }

    public static double l1Norm(DoubleMatrix1D vector) {
        return vector.aggregate(Functions.plus, Functions.identity);
    }

    public static DoubleMatrix1D columnCentroid(DoubleMatrix2D matrix) {
        return null;
    }
}

